/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application;

import java.util.List;
import org.teamapps.common.format.Color;
import org.teamapps.ux.application.Application;
import org.teamapps.ux.application.ApplicationChangeHandler;
import org.teamapps.ux.application.ResponsiveApplicationImpl;
import org.teamapps.ux.application.assembler.DesktopApplicationAssembler;
import org.teamapps.ux.application.assembler.MobileApplicationAssembler;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.session.CurrentSessionContext;

public interface ResponsiveApplication
extends Application {
    public static ResponsiveApplication createApplication() {
        return ResponsiveApplication.createApplication(null);
    }

    public static ResponsiveApplication createApplication(View applicationLauncher) {
        boolean mobileDevice = CurrentSessionContext.get().getClientInfo().isMobileDevice();
        if (mobileDevice) {
            MobileApplicationAssembler mobileAssembler = new MobileApplicationAssembler();
            mobileAssembler.setApplicationLauncher(applicationLauncher);
            return new ResponsiveApplicationImpl(mobileAssembler);
        }
        return new ResponsiveApplicationImpl(new DesktopApplicationAssembler());
    }

    public void addApplicationChangeHandler(ApplicationChangeHandler var1);

    public void removeApplicationChangeHandler(ApplicationChangeHandler var1);

    public void addApplicationView(View var1);

    public void removeApplicationView(View var1);

    public List<View> getApplicationViews();

    public List<Perspective> getPerspectives();

    public Perspective addPerspective(Perspective var1);

    public void showPerspective(Perspective var1);

    public Perspective getActivePerspective();

    public List<View> getActiveViews();

    public ToolbarButtonGroup addApplicationButtonGroup(ToolbarButtonGroup var1);

    public void removeApplicationButtonGroup(ToolbarButtonGroup var1);

    public List<ToolbarButtonGroup> getWorkspaceButtonGroups();

    public void setToolbarBackgroundColor(Color var1);
}

