/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.teamapps.dto.UiMapLocation;
import org.teamapps.dto.UiMapPolyline;
import org.teamapps.ux.component.map.Location;
import org.teamapps.ux.component.map.ShapeProperties;

public class Polyline {
    private final String clientId = UUID.randomUUID().toString();
    private final ShapeProperties properties;
    private final List<Location> locations;
    private PolylineListener listener;

    public Polyline(ShapeProperties properties, List<Location> locations) {
        this.properties = properties;
        this.locations = locations;
    }

    public UiMapPolyline createUiMapPolyline() {
        ArrayList<UiMapLocation> uiLocations = new ArrayList<UiMapLocation>();
        for (Location loc : this.locations) {
            uiLocations.add(loc.createUiLocation());
        }
        UiMapPolyline uiPolyline = new UiMapPolyline(uiLocations);
        uiPolyline.setShapeProperties(this.properties.createUiShapeProperties());
        return uiPolyline;
    }

    public Polyline addPoint(Location location) {
        this.locations.add(location);
        this.listener.handlePolyLinePointsAdded(this, Collections.singletonList(location));
        return this;
    }

    public Polyline addPoints(List<Location> locations) {
        this.locations.addAll(locations);
        this.listener.handlePolyLinePointsAdded(this, locations);
        return this;
    }

    public ShapeProperties getProperties() {
        return this.properties;
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public String getClientId() {
        return this.clientId;
    }

    void setListener(PolylineListener listener) {
        this.listener = listener;
    }

    public static interface PolylineListener {
        public void handlePolyLinePointsAdded(Polyline var1, List<Location> var2);
    }
}

