/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.teamapps.ux.component.timegraph.AbstractTimeGraphModel;
import org.teamapps.ux.component.timegraph.DoubleArrayLineChartDataPoints;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.LineChartDataPoints;
import org.teamapps.ux.component.timegraph.TimeGraphZoomLevel;
import org.teamapps.ux.component.timegraph.partitioning.TimePartitionUnit;

public class AggregatingTimeGraphModel
extends AbstractTimeGraphModel {
    private final ZoneId timeZone;
    private List<TimePartitionUnit> zoomLevels = Arrays.asList(TimePartitionUnit.YEAR, TimePartitionUnit.HALF_YEAR, TimePartitionUnit.QUARTER, TimePartitionUnit.MONTH, TimePartitionUnit.WEEK_MONDAY, TimePartitionUnit.DAY, TimePartitionUnit.HOURS_6, TimePartitionUnit.HOUR, TimePartitionUnit.MINUTES_30, TimePartitionUnit.MINUTES_15, TimePartitionUnit.MINUTES_5, TimePartitionUnit.MINUTES_2, TimePartitionUnit.MINUTE, TimePartitionUnit.SECONDS_30, TimePartitionUnit.SECONDS_10, TimePartitionUnit.SECONDS_5, TimePartitionUnit.SECONDS_2, TimePartitionUnit.SECOND, TimePartitionUnit.MILLISECOND_500, TimePartitionUnit.MILLISECOND_200, TimePartitionUnit.MILLISECOND_100, TimePartitionUnit.MILLISECOND_50, TimePartitionUnit.MILLISECOND_20, TimePartitionUnit.MILLISECOND_10, TimePartitionUnit.MILLISECOND_5, TimePartitionUnit.MILLISECOND_2, TimePartitionUnit.MILLISECOND);
    private Map<String, LineChartDataPoints> dataPointsByDataSeriesId = new HashMap<String, LineChartDataPoints>();
    private Map<String, AggregationPolicy> aggregationPolicyByDataSeriesId = new HashMap<String, AggregationPolicy>();
    private AggregationPolicy defaultAggregationPolicy = AggregationPolicy.FIRST_VALUE;
    private boolean addDataPointBeforeAndAfterQueryResult = true;

    public AggregatingTimeGraphModel(ZoneId timeZone) {
        this.timeZone = timeZone;
    }

    public AggregatingTimeGraphModel(ZoneId timeZone, List<TimePartitionUnit> zoomLevels) {
        this.timeZone = timeZone;
        this.zoomLevels = zoomLevels;
    }

    public void setZoomLevels(List<TimePartitionUnit> zoomLevels) {
        this.zoomLevels = zoomLevels;
        this.onDataChanged.fire(null);
    }

    public void setDataPointsByDataSeriesId(Map<String, LineChartDataPoints> dataPointsByDataSeriesId) {
        this.dataPointsByDataSeriesId.clear();
        this.dataPointsByDataSeriesId.putAll(dataPointsByDataSeriesId);
        this.onDataChanged.fire(null);
    }

    public void setDataPoints(String dataSeriesId, LineChartDataPoints dataPoints) {
        this.dataPointsByDataSeriesId.put(dataSeriesId, dataPoints);
        this.onDataChanged.fire(null);
    }

    public void setAggregationPolicyByDataSeriesId(Map<String, AggregationPolicy> aggregationPolicyByDataSeriesId) {
        this.aggregationPolicyByDataSeriesId.clear();
        this.aggregationPolicyByDataSeriesId.putAll(aggregationPolicyByDataSeriesId);
        this.onDataChanged.fire(null);
    }

    public void setAggregationPolicy(String dataSeriesId, AggregationPolicy aggregationPolicy) {
        this.aggregationPolicyByDataSeriesId.put(dataSeriesId, aggregationPolicy);
        this.onDataChanged.fire(null);
    }

    public void setDefaultAggregationPolicy(AggregationPolicy defaultAggregationPolicy) {
        this.defaultAggregationPolicy = defaultAggregationPolicy;
        this.onDataChanged.fire(null);
    }

    @Override
    @NotNull
    protected LineChartDataPoints getDataPoints(String dataSeriesId, TimeGraphZoomLevel partitionUnit, Interval interval) {
        TimePartitionUnit zoomLevel = this.zoomLevels.stream().filter(unit -> unit.getAverageMilliseconds() == partitionUnit.getApproximateMillisecondsPerDataPoint()).findFirst().orElse(this.zoomLevels.get(0));
        LineChartDataPoints dataPoints = this.dataPointsByDataSeriesId.get(dataSeriesId);
        return AggregatingTimeGraphModel.getAggregateDataPoints(dataPoints, zoomLevel, interval, this.aggregationPolicyByDataSeriesId.getOrDefault(dataSeriesId, this.defaultAggregationPolicy), this.timeZone, this.addDataPointBeforeAndAfterQueryResult);
    }

    @NotNull
    public static LineChartDataPoints getAggregateDataPoints(LineChartDataPoints dataPoints, TimePartitionUnit zoomLevel, Interval interval, AggregationPolicy aggregationPolicy, ZoneId timeZone, boolean addDataPointBeforeAndAfterQueryResult) {
        DoubleArrayList resultX = new DoubleArrayList(100);
        DoubleArrayList resultY = new DoubleArrayList(100);
        long currentPartitionStartMilli = AggregatingTimeGraphModel.getPartitionStart(interval.getMin(), zoomLevel, timeZone).toInstant().toEpochMilli();
        if (addDataPointBeforeAndAfterQueryResult) {
            currentPartitionStartMilli = zoomLevel.decrement(ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentPartitionStartMilli), timeZone)).toInstant().toEpochMilli();
        }
        long nextPartitionStartMilli = zoomLevel.increment(ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentPartitionStartMilli), timeZone)).toInstant().toEpochMilli();
        int i = 0;
        do {
            long tsMilli;
            Double aggregateValue = null;
            int count = 0;
            while (i < dataPoints.size() && (tsMilli = (long)dataPoints.getX(i)) < nextPartitionStartMilli) {
                if (tsMilli >= currentPartitionStartMilli) {
                    ++count;
                    double y = dataPoints.getY(i);
                    if (aggregationPolicy == AggregationPolicy.FIRST_VALUE) {
                        aggregateValue = aggregateValue == null ? y : aggregateValue;
                        break;
                    }
                    if (aggregationPolicy == AggregationPolicy.MAX) {
                        aggregateValue = aggregateValue == null || aggregateValue < y ? y : aggregateValue;
                    } else if (aggregationPolicy == AggregationPolicy.MIN) {
                        aggregateValue = aggregateValue == null || aggregateValue > y ? y : aggregateValue;
                    } else if (aggregationPolicy == AggregationPolicy.AVERAGE) {
                        aggregateValue = aggregateValue == null ? y : aggregateValue + y;
                    }
                }
                ++i;
            }
            if (count > 0 && aggregateValue != null) {
                resultX.add((double)currentPartitionStartMilli);
                if (aggregationPolicy == AggregationPolicy.AVERAGE) {
                    resultY.add(aggregateValue / (double)count);
                } else {
                    resultY.add(aggregateValue.doubleValue());
                }
            }
            currentPartitionStartMilli = nextPartitionStartMilli;
            nextPartitionStartMilli = zoomLevel.increment(AggregatingTimeGraphModel.getPartitionStart(nextPartitionStartMilli, zoomLevel, timeZone)).toInstant().toEpochMilli();
        } while (currentPartitionStartMilli <= interval.getMax() + (addDataPointBeforeAndAfterQueryResult ? zoomLevel.getAverageMilliseconds() : 0L));
        return new DoubleArrayLineChartDataPoints(resultX.toDoubleArray(), resultY.toDoubleArray());
    }

    private static ZonedDateTime getPartitionStart(long timestampMillis, TimePartitionUnit partitionUnit, ZoneId timeZone) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestampMillis), timeZone);
        return partitionUnit.getPartition(zonedDateTime);
    }

    @Override
    public List<? extends TimeGraphZoomLevel> getZoomLevels() {
        return this.zoomLevels;
    }

    @Override
    public Interval getDomainX(Collection<String> dataSeriesId) {
        long minX = this.dataPointsByDataSeriesId.values().stream().flatMapToDouble(LineChartDataPoints::streamX).mapToLong(x -> (long)x).min().orElse(0L);
        long maxX = this.dataPointsByDataSeriesId.values().stream().flatMapToDouble(LineChartDataPoints::streamX).mapToLong(x -> (long)x).max().orElse(1L);
        return new Interval(minX, maxX);
    }

    public boolean isAddDataPointBeforeAndAfterQueryResult() {
        return this.addDataPointBeforeAndAfterQueryResult;
    }

    public void setAddDataPointBeforeAndAfterQueryResult(boolean addDataPointBeforeAndAfterQueryResult) {
        this.addDataPointBeforeAndAfterQueryResult = addDataPointBeforeAndAfterQueryResult;
    }

    public static enum AggregationPolicy {
        FIRST_VALUE,
        MIN,
        AVERAGE,
        MAX;

    }
}

