/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.teamapps.common.format.Color;
import org.teamapps.dto.AbstractUiLineChartDataDisplay;
import org.teamapps.dto.UiLineChartBand;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.timegraph.AbstractLineChartDataDisplay;
import org.teamapps.ux.component.timegraph.LineChartCurveType;
import org.teamapps.ux.component.timegraph.LineChartDataDisplayChangeListener;

public class LineChartBand
extends AbstractLineChartDataDisplay {
    private final String id = UUID.randomUUID().toString();
    private LineChartDataDisplayChangeListener changeListener;
    private String upperBoundDataSeriesId;
    private String middleLineDataSeriesId;
    private String lowerBoundDataSeriesId;
    private LineChartCurveType curveType;
    private float dataDotRadius;
    private Color yAxisColor = Color.BLACK;
    private Color lineColor;
    private Color areaColor;

    public LineChartBand(String upperBoundDataSeriesId, String middleLineDataSeriesId, String lowerBoundDataSeriesId) {
        this(upperBoundDataSeriesId, middleLineDataSeriesId, lowerBoundDataSeriesId, LineChartCurveType.MONOTONE, 2.0f, new Color(73, 128, 192));
    }

    public LineChartBand(String upperBoundDataSeriesId, String middleLineDataSeriesId, String lowerBoundDataSeriesId, LineChartCurveType curveType, float dataDotRadius, Color lineColor) {
        this(upperBoundDataSeriesId, middleLineDataSeriesId, lowerBoundDataSeriesId, curveType, dataDotRadius, lineColor, null);
    }

    public LineChartBand(String upperBoundDataSeriesId, String middleLineDataSeriesId, String lowerBoundDataSeriesId, LineChartCurveType curveType, float dataDotRadius, Color lineColor, Color areaColor) {
        this.upperBoundDataSeriesId = upperBoundDataSeriesId;
        this.middleLineDataSeriesId = middleLineDataSeriesId;
        this.lowerBoundDataSeriesId = lowerBoundDataSeriesId;
        this.curveType = curveType;
        this.dataDotRadius = dataDotRadius;
        this.lineColor = lineColor;
        this.areaColor = areaColor;
    }

    public UiLineChartBand createUiFormat() {
        UiLineChartBand ui = new UiLineChartBand();
        this.mapAbstractLineChartDataDisplayProperties((AbstractUiLineChartDataDisplay)ui);
        ui.setUpperBoundDataSeriesId(this.upperBoundDataSeriesId);
        ui.setMiddleLineDataSeriesId(this.middleLineDataSeriesId);
        ui.setLowerBoundDataSeriesId(this.lowerBoundDataSeriesId);
        ui.setGraphType(this.curveType.toUiLineChartCurveType());
        ui.setDataDotRadius(this.dataDotRadius);
        ui.setLineColor(this.lineColor != null ? UiUtil.createUiColor(this.lineColor) : null);
        ui.setAreaColor(this.areaColor != null ? UiUtil.createUiColor(this.areaColor) : null);
        return ui;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<String> getDataSeriesIds() {
        return Arrays.asList(this.upperBoundDataSeriesId, this.middleLineDataSeriesId, this.lowerBoundDataSeriesId);
    }

    @Override
    public void setChangeListener(LineChartDataDisplayChangeListener listener) {
        this.changeListener = listener;
    }

    public LineChartCurveType getCurveType() {
        return this.curveType;
    }

    public LineChartBand setCurveType(LineChartCurveType curveType) {
        this.curveType = curveType;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public float getDataDotRadius() {
        return this.dataDotRadius;
    }

    public LineChartBand setDataDotRadius(float dataDotRadius) {
        this.dataDotRadius = dataDotRadius;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public LineChartBand setLineColor(Color lineColor) {
        this.lineColor = lineColor;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public Color getAreaColor() {
        return this.areaColor;
    }

    public LineChartBand setAreaColor(Color areaColor) {
        this.areaColor = areaColor;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }
}

