/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.i18n;

import java.util.Locale;
import java.util.MissingResourceException;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.teamapps.ux.i18n.ResourceBundleTranslationProvider;

public class ResourceBundleTranslationProviderTest {
    @Test
    public void shouldReturnAvailableTranslations() throws Exception {
        ResourceBundleTranslationProvider provider = new ResourceBundleTranslationProvider("translations/Translations", Locale.GERMAN);
        Assertions.assertThat((String)provider.getTranslation("allLanguages", Locale.GERMAN)).isEqualTo("alle Sprachen");
        Assertions.assertThat((String)provider.getTranslation("allLanguages", Locale.ENGLISH)).isEqualTo("all languages");
        Assertions.assertThat((String)provider.getTranslation("allLanguages", Locale.FRENCH)).isEqualTo("toutes les langues");
    }

    @Test
    public void shouldFallbackToDefaultLocaleIfLocaleNotPresent() throws Exception {
        ResourceBundleTranslationProvider provider = new ResourceBundleTranslationProvider("translations/Translations", Locale.ENGLISH);
        Assertions.assertThat((String)provider.getTranslation("allLanguages", Locale.ITALIAN)).isEqualTo("all languages");
    }

    @Test
    public void shouldFallbackToDefaultLocaleIfKeyNotPresentInLocale() throws Exception {
        ResourceBundleTranslationProvider provider = new ResourceBundleTranslationProvider("translations/Translations", Locale.ENGLISH);
    }

    @Test
    public void shouldThrowIfTranslationNotPresent() throws Exception {
        ResourceBundleTranslationProvider provider = new ResourceBundleTranslationProvider("translations/Translations", Locale.ENGLISH);
        Assertions.assertThatThrownBy(() -> provider.getTranslation("asdf", Locale.GERMAN)).isInstanceOf(MissingResourceException.class);
    }
}

