/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.glassfish.jersey.uri.UriTemplate;
import org.junit.Test;
import org.teamapps.ux.session.navigation.NavigationHistoryOperation;
import org.teamapps.ux.session.navigation.Route;
import org.teamapps.ux.session.navigation.RouteInfo;
import org.teamapps.ux.session.navigation.Router;

public class RouterTest {
    @Test
    public void pathRemainderSuffix() {
        UriTemplate uriTemplate = new UriTemplate("/asdf/x{_remainder:(/.*)?}");
        RouterTest.testUriPatternMatches(uriTemplate, "/asdf/x", Assertions.entry((Object)"_remainder", (Object)""));
        RouterTest.testUriPatternMatches(uriTemplate, "/asdf/x/foo", Assertions.entry((Object)"_remainder", (Object)"/foo"));
        Assertions.assertThat((boolean)uriTemplate.match((CharSequence)"/asdf/xyz", new HashMap())).isFalse();
    }

    @SafeVarargs
    private static void testUriPatternMatches(UriTemplate uriTemplate, String path, MapEntry<String, String> ... expectedEntries) {
        HashMap map = new HashMap();
        Assertions.assertThat((boolean)uriTemplate.match((CharSequence)path, map)).isTrue();
        Assertions.assertThat(map).containsOnly(expectedEntries);
    }

    @Test
    public void setPath() {
        Router router = new Router("/");
        router.setPath("x", NavigationHistoryOperation.PUSH);
        router.setPathSupplier(() -> "fromSupplier", NavigationHistoryOperation.REPLACE);
        router.setRouteSupplier(() -> new Route("fromRouteSupplier", Map.of()), NavigationHistoryOperation.REPLACE);
        RouteInfo routeInfo = router.calculateRouteInfo();
        Assertions.assertThat((String)routeInfo.getRoute().getPath()).isEqualTo("/x");
        Assertions.assertThat((boolean)routeInfo.isPathChangeWorthStatePush()).isTrue();
    }

    @Test
    public void setPath2() {
        Router router = new Router("/");
        router.setPath("x", NavigationHistoryOperation.REPLACE);
        router.setPathSupplier(() -> "fromSupplier", NavigationHistoryOperation.PUSH);
        router.setRouteSupplier(() -> new Route("fromRouteSupplier", Map.of()), NavigationHistoryOperation.PUSH);
        RouteInfo routeInfo = router.calculateRouteInfo();
        Assertions.assertThat((String)routeInfo.getRoute().getPath()).isEqualTo("/x");
        Assertions.assertThat((boolean)routeInfo.isPathChangeWorthStatePush()).isFalse();
    }

    @Test
    public void setQueryParameter() {
        Router router = new Router("/");
        router.setQueryParameter("x", "xValue", NavigationHistoryOperation.PUSH);
        router.setQueryParameterSupplier("x", () -> "fromSupplier", NavigationHistoryOperation.REPLACE);
        router.addQueryParametersSupplier(() -> Map.of("x", "fromSupplier2"), NavigationHistoryOperation.REPLACE);
        router.setRouteSupplier(() -> new Route("/", Map.of("x", "fromRouteSupplier")), NavigationHistoryOperation.REPLACE);
        RouteInfo routeInfo = router.calculateRouteInfo();
        Assertions.assertThat((String)routeInfo.getRoute().getQueryParam("x")).isEqualTo("xValue");
        Assertions.assertThat((Collection)routeInfo.getQueryParamNamesWorthStatePush()).contains((Object[])new String[]{"x"});
    }

    @Test
    public void setQueryParameter2() {
        Router router = new Router("/");
        router.setQueryParameter("x", "xValue", NavigationHistoryOperation.REPLACE);
        router.setQueryParameterSupplier("x", () -> "fromSupplier", NavigationHistoryOperation.PUSH);
        router.addQueryParametersSupplier(() -> Map.of("x", "fromSupplier2"), NavigationHistoryOperation.PUSH);
        router.setRouteSupplier(() -> new Route("/", Map.of("x", "fromRouteSupplier")), NavigationHistoryOperation.PUSH);
        RouteInfo routeInfo = router.calculateRouteInfo();
        Assertions.assertThat((String)routeInfo.getRoute().getQueryParam("x")).isEqualTo("xValue");
        Assertions.assertThat((Collection)routeInfo.getQueryParamNamesWorthStatePush()).doesNotContain((Object[])new String[]{"x"});
    }

    @Test
    public void setPathSupplier() {
        Router router = new Router("/");
        router.setPathSupplier(() -> "fromPathSupplier", NavigationHistoryOperation.PUSH);
        router.setRouteSupplier(() -> new Route("fromRouteSupplier", Map.of()), NavigationHistoryOperation.REPLACE);
        RouteInfo routeInfo = router.calculateRouteInfo();
        Assertions.assertThat((String)routeInfo.getRoute().getPath()).isEqualTo("/fromPathSupplier");
        Assertions.assertThat((boolean)routeInfo.isPathChangeWorthStatePush()).isTrue();
    }

    @Test
    public void setPathSupplier2() {
        Router router = new Router("/");
        router.setPathSupplier(() -> "fromPathSupplier", NavigationHistoryOperation.REPLACE);
        router.setRouteSupplier(() -> new Route("fromRouteSupplier", Map.of()), NavigationHistoryOperation.PUSH);
        RouteInfo routeInfo = router.calculateRouteInfo();
        Assertions.assertThat((String)routeInfo.getRoute().getPath()).isEqualTo("/fromPathSupplier");
        Assertions.assertThat((boolean)routeInfo.isPathChangeWorthStatePush()).isFalse();
    }

    @Test
    public void setQueryParameterSupplier() {
        Router router = new Router("/");
        router.setQueryParameterSupplier("x", () -> "fromSupplier", NavigationHistoryOperation.PUSH);
        router.addQueryParametersSupplier(() -> Map.of("x", "fromSupplier2"), NavigationHistoryOperation.REPLACE);
        router.setRouteSupplier(() -> new Route("/", Map.of("x", "fromRouteSupplier")), NavigationHistoryOperation.REPLACE);
        RouteInfo routeInfo = router.calculateRouteInfo();
        Assertions.assertThat((String)routeInfo.getRoute().getQueryParam("x")).isEqualTo("fromSupplier");
        Assertions.assertThat((Collection)routeInfo.getQueryParamNamesWorthStatePush()).contains((Object[])new String[]{"x"});
    }

    @Test
    public void setQueryParameterSupplier2() {
        Router router = new Router("/");
        router.setQueryParameterSupplier("x", () -> "fromSupplier", NavigationHistoryOperation.REPLACE);
        router.addQueryParametersSupplier(() -> Map.of("x", "fromSupplier2"), NavigationHistoryOperation.PUSH);
        router.setRouteSupplier(() -> new Route("/", Map.of("x", "fromRouteSupplier")), NavigationHistoryOperation.PUSH);
        RouteInfo routeInfo = router.calculateRouteInfo();
        Assertions.assertThat((String)routeInfo.getRoute().getQueryParam("x")).isEqualTo("fromSupplier");
        Assertions.assertThat((Collection)routeInfo.getQueryParamNamesWorthStatePush()).doesNotContain((Object[])new String[]{"x"});
    }

    @Test
    public void setQueryParametersSupplier() {
        Router router = new Router("/");
        router.addQueryParametersSupplier(() -> Map.of("x", "fromParametersSupplier"), NavigationHistoryOperation.PUSH);
        router.setRouteSupplier(() -> new Route("/", Map.of("x", "fromRouteSupplier")), NavigationHistoryOperation.REPLACE);
        RouteInfo routeInfo = router.calculateRouteInfo();
        Assertions.assertThat((String)routeInfo.getRoute().getQueryParam("x")).isEqualTo("fromParametersSupplier");
        Assertions.assertThat((Collection)routeInfo.getQueryParamNamesWorthStatePush()).contains((Object[])new String[]{"x"});
    }

    @Test
    public void setQueryParametersSupplier2() {
        Router router = new Router("/");
        router.addQueryParametersSupplier(() -> Map.of("x", "fromParametersSupplier"), NavigationHistoryOperation.REPLACE);
        router.setRouteSupplier(() -> new Route("/", Map.of("x", "fromRouteSupplier")), NavigationHistoryOperation.PUSH);
        RouteInfo routeInfo = router.calculateRouteInfo();
        Assertions.assertThat((String)routeInfo.getRoute().getQueryParam("x")).isEqualTo("fromParametersSupplier");
        Assertions.assertThat((Collection)routeInfo.getQueryParamNamesWorthStatePush()).doesNotContain((Object[])new String[]{"x"});
    }

    @Test
    public void setRouteSupplier() {
        Router router = new Router("/");
        router.setRouteSupplier(() -> new Route("fromRouteSupplier", Map.of()), NavigationHistoryOperation.PUSH);
        RouteInfo routeInfo = router.calculateRouteInfo();
        Assertions.assertThat((String)routeInfo.getRoute().getPath()).isEqualTo("/fromRouteSupplier");
        Assertions.assertThat((boolean)routeInfo.isPathChangeWorthStatePush()).isTrue();
    }

    @Test
    public void setRouteSupplier2() {
        Router router = new Router("/");
        router.setRouteSupplier(() -> new Route("fromRouteSupplier", Map.of()), NavigationHistoryOperation.REPLACE);
        RouteInfo routeInfo = router.calculateRouteInfo();
        Assertions.assertThat((String)routeInfo.getRoute().getPath()).isEqualTo("/fromRouteSupplier");
        Assertions.assertThat((boolean)routeInfo.isPathChangeWorthStatePush()).isFalse();
    }

    @Test
    public void matchesPath() throws Exception {
        Assertions.assertThat((boolean)new Router("").matchesPath("/a/b/c")).isTrue();
        Assertions.assertThat((boolean)new Router("/").matchesPath("/a/b/c")).isTrue();
        Assertions.assertThat((boolean)new Router("a").matchesPath("/a/b/c")).isTrue();
        Assertions.assertThat((boolean)new Router("/a").matchesPath("/a/b/c")).isTrue();
        Assertions.assertThat((boolean)new Router("a/b").matchesPath("/a/b/c")).isTrue();
        Assertions.assertThat((boolean)new Router("/a/b").matchesPath("/a/b/c")).isTrue();
        Assertions.assertThat((boolean)new Router("/a/{v}/b").matchesPath("/a/xxx/b")).isTrue();
        Assertions.assertThat((boolean)new Router("/a/{v}/b").matchesPath("/a/xxx/b/c")).isTrue();
        Assertions.assertThat((boolean)new Router("x").matchesPath("/a/b/c")).isFalse();
        Assertions.assertThat((boolean)new Router("/x").matchesPath("/a/b/c")).isFalse();
        Assertions.assertThat((boolean)new Router("a/x").matchesPath("/a/b/c")).isFalse();
        Assertions.assertThat((boolean)new Router("/a/x").matchesPath("/a/b/c")).isFalse();
        Assertions.assertThat((boolean)new Router("/a/b/c/d").matchesPath("/a/b/c")).isFalse();
        Assertions.assertThat((boolean)new Router("/a/{v}/b").matchesPath("/a/xxx/c")).isFalse();
        Assertions.assertThat((boolean)new Router("/a/{v}/b").matchesPath("/a/xxx")).isFalse();
    }

    @Test
    public void matchesPathPrefix() {
        Assertions.assertThat((boolean)new Router("").matchesPathPrefix("/a/b")).isFalse();
        Assertions.assertThat((boolean)new Router("/").matchesPathPrefix("/a/b")).isFalse();
        Assertions.assertThat((boolean)new Router("a").matchesPathPrefix("/a/b")).isFalse();
        Assertions.assertThat((boolean)new Router("/a").matchesPathPrefix("/a/b")).isFalse();
        Assertions.assertThat((boolean)new Router("x").matchesPathPrefix("/a/b")).isFalse();
        Assertions.assertThat((boolean)new Router("/a/x").matchesPathPrefix("/a/b")).isFalse();
        Assertions.assertThat((boolean)new Router("/a/{v}/b").matchesPathPrefix("/a")).isFalse();
        Assertions.assertThat((boolean)new Router("/a/{v}/b").matchesPathPrefix("/a/b")).isFalse();
        Assertions.assertThat((boolean)new Router("/a/{v}/b").matchesPathPrefix("/a/b/c")).isFalse();
        Assertions.assertThat((boolean)new Router("a/b").matchesPathPrefix("/a/b")).isTrue();
        Assertions.assertThat((boolean)new Router("/a/b").matchesPathPrefix("/a/b")).isTrue();
        Assertions.assertThat((boolean)new Router("/a/{v}/b").matchesPathPrefix("/a/xxx/b")).isTrue();
    }
}

