/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component;

import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.ux.component.ClientObject;
import org.teamapps.ux.component.absolutelayout.Length;
import org.teamapps.ux.component.format.Shadow;
import org.teamapps.ux.component.format.Spacing;

public interface Component
extends ClientObject {
    public void setParent(Component var1);

    public Component getParent();

    public boolean isVisible();

    public void setVisible(boolean var1);

    public void toggleCssClass(String var1, String var2, boolean var3);

    default public void toggleCssClass(String className, boolean enabled) {
        this.toggleCssClass(null, className, enabled);
    }

    public void setCssStyle(String var1, String var2, String var3);

    default public void setCssStyle(String propertyName, String value) {
        this.setCssStyle(null, propertyName, value);
    }

    public void setAttribute(String var1, String var2, String var3);

    default public void setAttribute(String attributeName, String value) {
        this.setAttribute(null, attributeName, value);
    }

    default public void setMinWidth(Length minWidth) {
        this.setCssStyle("min-width", minWidth.toCssString());
    }

    default public void setMaxWidth(Length maxWidth) {
        this.setCssStyle("max-width", maxWidth.toCssString());
    }

    default public void setMinHeight(Length minHeight) {
        this.setCssStyle("min-height", minHeight.toCssString());
    }

    default public void setMaxHeight(Length maxHeight) {
        this.setCssStyle("max-height", maxHeight.toCssString());
    }

    default public void setMargin(Spacing margin) {
        this.setCssStyle("margin", margin.toCssString());
    }

    default public void setShadow(Shadow shadow) {
        this.setCssStyle("box-shadow", shadow.toCssString());
    }

    default public void setAriaLabel(String ariaLabel) {
        this.setAttribute("aria-label", ariaLabel);
    }

    default public void setHtmlTitle(String title) {
        this.setAttribute("title", title);
    }

    public static UiClientObjectReference createUiClientObjectReference(Component component) {
        if (component == null) {
            return null;
        }
        return component.createUiReference();
    }
}

