/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RoutingUtil {
    public static Map<String, String> parseQueryParams(String query) {
        String[] assignments;
        if (StringUtils.isBlank((CharSequence)query)) {
            return Map.of();
        }
        if (query.startsWith("?")) {
            query = query.substring(1);
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            return Map.of();
        }
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        for (String assignment : assignments = query.split("&")) {
            int equalsSignIndex = assignment.indexOf("=");
            queryParams.put(URLDecoder.decode(assignment.substring(0, equalsSignIndex), StandardCharsets.UTF_8), URLDecoder.decode(assignment.substring(equalsSignIndex + 1), StandardCharsets.UTF_8));
        }
        return queryParams;
    }

    public static String normalizePath(String prefix) {
        if (RoutingUtil.isEmptyPath(prefix)) {
            return "/";
        }
        prefix = RoutingUtil.withSingleLeadingSlash(prefix);
        while (prefix.length() > 1 && prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    public static boolean isEmptyPath(String prefix) {
        return StringUtils.isBlank((CharSequence)prefix) || prefix.equals("/");
    }

    public static String withSingleLeadingSlash(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return "/";
        }
        while (((String)path).startsWith("//")) {
            path = ((String)path).substring(1);
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return path;
    }

    public static String concatenatePaths(String prefix, String suffix) {
        prefix = RoutingUtil.normalizePath(prefix);
        suffix = RoutingUtil.withSingleLeadingSlash(suffix);
        return RoutingUtil.normalizePath(prefix + suffix);
    }

    public static String removePrefix(String path, String prefix) {
        path = RoutingUtil.normalizePath(path);
        if ((prefix = RoutingUtil.normalizePath(prefix)).equals("/")) {
            return path;
        }
        if (path.startsWith(prefix)) {
            return RoutingUtil.normalizePath(path.substring(prefix.length()));
        }
        throw new IllegalArgumentException("Cannot remove prefix " + prefix + " from path " + path);
    }
}

