/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.data.extract;

import org.junit.Assert;
import org.junit.Test;
import org.teamapps.data.extract.BeanPropertyExtractor;

public class BeanPropertyExtractorTest {
    @Test
    public void testGetValue() throws Exception {
        BeanPropertyExtractor extractor = new BeanPropertyExtractor();
        Object value = extractor.getValue((Object)new A(), "q");
        Assert.assertEquals((Object)"qValue", (Object)value);
    }

    @Test
    public void testWontGetPrivateFieldValue() throws Exception {
        BeanPropertyExtractor extractor = new BeanPropertyExtractor();
        Object value = extractor.getValue((Object)new A(), "publicField");
        Assert.assertNull((Object)value);
    }

    @Test
    public void testValueExtractorsGetCachedSeparatelyDependingOnFallbackToFields() throws Exception {
        BeanPropertyExtractor extractor = new BeanPropertyExtractor();
        Assert.assertNull((Object)extractor.getValue((Object)new A(), "x"));
        BeanPropertyExtractor extractor2 = new BeanPropertyExtractor(true);
        Assert.assertEquals((Object)"xValue", (Object)extractor2.getValue((Object)new A(), "x"));
    }

    @Test
    public void testGetPublicFieldValue() throws Exception {
        BeanPropertyExtractor extractor = new BeanPropertyExtractor(true);
        Object value = extractor.getValue((Object)new A(), "publicField");
        Assert.assertEquals((Object)1337, (Object)value);
    }

    @Test
    public void testGetPrivateFieldValue() throws Exception {
        BeanPropertyExtractor extractor = new BeanPropertyExtractor(true);
        Object value = extractor.getValue((Object)new A(), "privateField");
        Assert.assertEquals((Object)2337, (Object)value);
    }

    @Test
    public void testGetsBooleanGetter() throws Exception {
        BeanPropertyExtractor extractor = new BeanPropertyExtractor();
        Object value = extractor.getValue((Object)new A(), "s");
        Assert.assertEquals((Object)true, (Object)value);
    }

    @Test
    public void testAddCustomValueExtractor() throws Exception {
        BeanPropertyExtractor extractor = new BeanPropertyExtractor();
        extractor.addProperty("blah", object -> "blahValue");
        Object value = extractor.getValue((Object)new A(), "blah");
        Assert.assertEquals((Object)"blahValue", (Object)value);
    }

    @Test
    public void testAddCustomValueExtractorOverwritesProperty() throws Exception {
        BeanPropertyExtractor extractor = new BeanPropertyExtractor();
        extractor.addProperty("q", object -> "overwrittenQValue");
        Object value = extractor.getValue((Object)new A(), "q");
        Assert.assertEquals((Object)"overwrittenQValue", (Object)value);
    }

    public static class A {
        private final String q = "qValue";
        private final String r = "rValue";
        public int publicField = 1337;
        private final int privateField = 2337;
        private final String x = "xValue";

        public String getQ() {
            return "qValue";
        }

        public boolean isS() {
            return true;
        }
    }
}

