/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;

public class JacksonTypeInfoWithTeamAppsJacksonTypeIdResolverTest {
    @Before
    public void setUp() throws Exception {
        TeamAppsJacksonTypeIdResolver.registerPojoClass(Pojo.class);
        TeamAppsJacksonTypeIdResolver.registerPojoClass(ObjectReferencePojo.class);
        TeamAppsJacksonTypeIdResolver.registerPojoClass(ObjectListReferencePojo.class);
        TeamAppsJacksonTypeIdResolver.registerPojoClass(ConcreteReferencePojo.class);
        TeamAppsJacksonTypeIdResolver.registerPojoClass(ClassLevelTypeInfoPojo.class);
    }

    @Test
    public void testTypeInfoOnObjectReference() throws Exception {
        String json = new ObjectMapper().writeValueAsString((Object)new ObjectReferencePojo(new Pojo()));
        System.out.println(json);
        Assertions.assertThat((String)json).isEqualTo("{\"x\":{\"_attribute_type\":\"org.teamapps.json.JacksonTypeInfoWithTeamAppsJacksonTypeIdResolverTest.Pojo\",\"x\":123}}");
        ObjectReferencePojo deserializedValue = (ObjectReferencePojo)new ObjectMapper().readValue(json, ObjectReferencePojo.class);
        Assertions.assertThat((Object)deserializedValue.getX()).isInstanceOf(Pojo.class);
    }

    @Test
    public void testClassLevelTypeInfo() throws Exception {
        String json = new ObjectMapper().writeValueAsString((Object)new ClassLevelTypeInfoPojo());
        System.out.println(json);
        Assertions.assertThat((String)json).contains(new CharSequence[]{"\"_class_type\":\"org.teamapps.json.JacksonTypeInfoWithTeamAppsJacksonTypeIdResolverTest.ClassLevelTypeInfoPojo\""});
        ClassLevelTypeInfoPojo deserializedValue = (ClassLevelTypeInfoPojo)new ObjectMapper().readValue(json, ClassLevelTypeInfoPojo.class);
        Assertions.assertThat((Object)deserializedValue).isInstanceOf(ClassLevelTypeInfoPojo.class);
    }

    @Test
    public void testObjectListTypeInfo() throws Exception {
        String json = new ObjectMapper().writeValueAsString((Object)new ObjectListReferencePojo(Arrays.asList(new Pojo(), new Pojo())));
        System.out.println(json);
        Assertions.assertThat((String)json).contains(new CharSequence[]{"{\"x\":[{\"_list_attribute_type\":\"org.teamapps.json.JacksonTypeInfoWithTeamAppsJacksonTypeIdResolverTest.Pojo\",\"x\":123},{\"_list_attribute_type\":\"org.teamapps.json.JacksonTypeInfoWithTeamAppsJacksonTypeIdResolverTest.Pojo\",\"x\":123}]}"});
        ObjectListReferencePojo deserializedValue = (ObjectListReferencePojo)new ObjectMapper().readValue(json, ObjectListReferencePojo.class);
        Assertions.assertThat(deserializedValue.getX().get(0)).isInstanceOf(Pojo.class);
    }

    @Test
    public void attributeLevelWins() throws Exception {
        String json = new ObjectMapper().writeValueAsString((Object)new ObjectListReferencePojo(Arrays.asList(new ClassLevelTypeInfoPojo(), new ClassLevelTypeInfoPojo())));
        System.out.println(json);
        Assertions.assertThat((String)json).isEqualTo("{\"x\":[{\"_list_attribute_type\":\"org.teamapps.json.JacksonTypeInfoWithTeamAppsJacksonTypeIdResolverTest.ClassLevelTypeInfoPojo\",\"x\":123},{\"_list_attribute_type\":\"org.teamapps.json.JacksonTypeInfoWithTeamAppsJacksonTypeIdResolverTest.ClassLevelTypeInfoPojo\",\"x\":123}]}");
        ObjectListReferencePojo deserializedValue = (ObjectListReferencePojo)new ObjectMapper().readValue(json, ObjectListReferencePojo.class);
        Assertions.assertThat(deserializedValue.getX().get(0)).isInstanceOf(ClassLevelTypeInfoPojo.class);
    }

    @Test
    public void testConcreteClassReferenceToAnnotatedObject() throws Exception {
        String json = new ObjectMapper().writeValueAsString((Object)new ConcreteReferencePojo(new ClassLevelTypeInfoPojo()));
        System.out.println(json);
        Assertions.assertThat((String)json).isEqualTo("{\"x\":{\"_class_type\":\"org.teamapps.json.JacksonTypeInfoWithTeamAppsJacksonTypeIdResolverTest.ClassLevelTypeInfoPojo\",\"x\":123}}");
    }

    @Test
    public void testConcreteListReferencePojo() throws Exception {
        String json = new ObjectMapper().writeValueAsString((Object)new ConcreteListReferencePojo(Collections.singletonList(new Pojo()), Collections.singletonList(new Pojo())));
        System.out.println(json);
        Assertions.assertThat((String)json).isEqualTo("{\"annotated\":[{\"_list_attribute_type\":\"org.teamapps.json.JacksonTypeInfoWithTeamAppsJacksonTypeIdResolverTest.Pojo\",\"x\":123}],\"nonAnnotated\":[{\"x\":123}]}");
        ConcreteListReferencePojo deserializedValue = (ConcreteListReferencePojo)new ObjectMapper().readValue(json, ConcreteListReferencePojo.class);
        Assertions.assertThat((Object)deserializedValue.getAnnotated().get(0)).isInstanceOf(Pojo.class);
        Assertions.assertThat((Object)deserializedValue.getNonAnnotated().get(0)).isInstanceOf(Pojo.class);
    }

    @Test
    public void testObjectReferenceContainsList() throws Exception {
        ArrayList<Pojo> arrayList = new ArrayList<Pojo>();
        arrayList.add(new Pojo());
        arrayList.add(new Pojo());
        arrayList.add(new Pojo());
        String json = new ObjectMapper().writeValueAsString((Object)new ObjectReferencePojo(arrayList));
        System.out.println(json);
        ObjectReferencePojo deserializedValue = (ObjectReferencePojo)new ObjectMapper().readValue(json, ObjectReferencePojo.class);
        Assertions.assertThat((Object)deserializedValue.getX()).isInstanceOf(ArrayList.class);
    }

    public static class Pojo {
        int x = 123;

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_class_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
    public static class ClassLevelTypeInfoPojo {
        int x = 123;

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }
    }

    public static class ConcreteListReferencePojo {
        @JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_list_attribute_type")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
        public List<Pojo> annotated;
        public List<Pojo> nonAnnotated;

        public ConcreteListReferencePojo() {
        }

        public ConcreteListReferencePojo(List<Pojo> annotated, List<Pojo> nonAnnotated) {
            this.annotated = annotated;
            this.nonAnnotated = nonAnnotated;
        }

        public List<Pojo> getAnnotated() {
            return this.annotated;
        }

        public void setAnnotated(List<Pojo> annotated) {
            this.annotated = annotated;
        }

        public List<Pojo> getNonAnnotated() {
            return this.nonAnnotated;
        }

        public void setNonAnnotated(List<Pojo> nonAnnotated) {
            this.nonAnnotated = nonAnnotated;
        }
    }

    public static class ConcreteReferencePojo {
        public ClassLevelTypeInfoPojo x;

        public ConcreteReferencePojo() {
        }

        public ConcreteReferencePojo(ClassLevelTypeInfoPojo x) {
            this.x = x;
        }

        public ClassLevelTypeInfoPojo getX() {
            return this.x;
        }

        public void setX(ClassLevelTypeInfoPojo x) {
            this.x = x;
        }
    }

    public static class ObjectListReferencePojo {
        @JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_list_attribute_type")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
        public List x;

        public ObjectListReferencePojo() {
        }

        public ObjectListReferencePojo(List x) {
            this.x = x;
        }

        public List getX() {
            return this.x;
        }

        public void setX(List x) {
            this.x = x;
        }
    }

    public static class ObjectReferencePojo {
        @JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_attribute_type")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
        public Object x;

        public ObjectReferencePojo() {
        }

        public ObjectReferencePojo(Object x) {
            this.x = x;
        }

        public Object getX() {
            return this.x;
        }

        public void setX(Object x) {
            this.x = x;
        }
    }
}

