/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.template.htmltemplate;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.teamapps.dto.UiHtmlTemplate;
import org.teamapps.dto.UiTemplate;
import org.teamapps.ux.component.template.Template;

public class HtmlTemplate
implements Template {
    private static final Pattern PLACE_HOLDER_REGEX = Pattern.compile("\\{\\{(\\w+)\\}\\}");
    private final String html;
    private final List<String> propertyNames;

    public HtmlTemplate(String htmlTemplateString) {
        this.html = htmlTemplateString;
        this.propertyNames = PLACE_HOLDER_REGEX.matcher(this.html).results().map(matchResult -> matchResult.group(1)).collect(Collectors.toList());
    }

    @Override
    public UiTemplate createUiTemplate() {
        return new UiHtmlTemplate(this.html);
    }

    @Override
    public List<String> getPropertyNames() {
        return this.propertyNames;
    }
}

