/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.teamapps.util.ReflectionUtil;
import org.teamapps.ux.session.navigation.ParameterConverterProvider;
import org.teamapps.ux.session.navigation.RouteHandler;
import org.teamapps.ux.session.navigation.RoutingUtil;
import org.teamapps.ux.session.navigation.annotation.PathParameter;
import org.teamapps.ux.session.navigation.annotation.QueryParameter;
import org.teamapps.ux.session.navigation.annotation.RoutingPath;

public class AnnotationBasedRouteHandlerFactory {
    private final ParamConverterProvider converterProvider;

    public AnnotationBasedRouteHandlerFactory() {
        this(new ParameterConverterProvider());
    }

    public AnnotationBasedRouteHandlerFactory(ParamConverterProvider converterProvider) {
        this.converterProvider = converterProvider;
    }

    public List<AnnotationBasedRouteHandler> createRouteHandlers(Object annotatedClassInstance) {
        RoutingPath classLevelPathAnnotation = annotatedClassInstance.getClass().getAnnotation(RoutingPath.class);
        String pathPrefix = classLevelPathAnnotation != null ? classLevelPathAnnotation.value() : "";
        List<Method> routingMethods = ReflectionUtil.findMethods(annotatedClassInstance.getClass(), method -> method.isAnnotationPresent(RoutingPath.class));
        return routingMethods.stream().peek(m -> {
            if (!m.trySetAccessible()) {
                throw new RuntimeException("Cannot make method " + m + " accessible!");
            }
        }).map(m -> this.createRoutingMethodInfo((Method)m, pathPrefix)).map(routingMethodInfo -> new AnnotationBasedRouteHandler((RoutingMethodInfo)routingMethodInfo, annotatedClassInstance)).collect(Collectors.toList());
    }

    private RoutingMethodInfo createRoutingMethodInfo(Method m, String pathPrefix) {
        RoutingPath pathAnnotation = m.getAnnotation(RoutingPath.class);
        String pathTemplate = RoutingUtil.concatenatePaths(pathPrefix, pathAnnotation.value());
        Class<?>[] parameterTypes = m.getParameterTypes();
        Type[] genericParameterTypes = m.getGenericParameterTypes();
        Parameter[] methodParameters = m.getParameters();
        ParameterValueExtractor[] methodParameterExtractors = new ParameterValueExtractor[methodParameters.length];
        for (int i = 0; i < methodParameters.length; ++i) {
            Parameter parameter = methodParameters[i];
            PathParameter pathParam = parameter.getAnnotation(PathParameter.class);
            QueryParameter queryParam = parameter.getAnnotation(QueryParameter.class);
            ParamConverter converter = this.converterProvider.getConverter(parameterTypes[i], genericParameterTypes[i], parameter.getAnnotations());
            methodParameterExtractors[i] = pathParam != null ? (path, pathParams, queryParams) -> converter.fromString((String)pathParams.get(pathParam.value())) : (queryParam != null ? (path, pathParams, queryParams) -> {
                String paramValue = (String)queryParams.get(queryParam.value());
                return StringUtils.isNotBlank((CharSequence)paramValue) ? converter.fromString(paramValue) : null;
            } : (path, pathParams, queryParams) -> null);
        }
        return new RoutingMethodInfo(pathTemplate, pathAnnotation.exact(), m, methodParameterExtractors);
    }

    public static class AnnotationBasedRouteHandler
    implements RouteHandler {
        private final RoutingMethodInfo routingMethodInfo;
        private final Object annotatedClassInstance;

        public AnnotationBasedRouteHandler(RoutingMethodInfo routingMethodInfo, Object annotatedClassInstance) {
            this.routingMethodInfo = routingMethodInfo;
            this.annotatedClassInstance = annotatedClassInstance;
        }

        @Override
        public void handle(String path, Map<String, String> pathParams, Map<String, String> queryParams) {
            Object[] argumentValues = Arrays.stream(this.routingMethodInfo.getMethodParameterExtractors()).map(extractor -> extractor.extract(path, pathParams, queryParams)).toArray();
            try {
                this.routingMethodInfo.getMethod().invoke(this.annotatedClassInstance, argumentValues);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String getPathTemplate() {
            return this.routingMethodInfo.getPathTemplate();
        }

        public boolean isExact() {
            return this.routingMethodInfo.isExact();
        }
    }

    private static class RoutingMethodInfo {
        private final String pathTemplate;
        private final boolean exact;
        private final Method method;
        private final ParameterValueExtractor[] methodParameterExtractors;

        public RoutingMethodInfo(String pathTemplate, boolean exact, Method method, ParameterValueExtractor[] methodParameterExtractors) {
            this.pathTemplate = pathTemplate;
            this.exact = exact;
            this.method = method;
            this.methodParameterExtractors = methodParameterExtractors;
        }

        public String getPathTemplate() {
            return this.pathTemplate;
        }

        public boolean isExact() {
            return this.exact;
        }

        public Method getMethod() {
            return this.method;
        }

        public ParameterValueExtractor[] getMethodParameterExtractors() {
            return this.methodParameterExtractors;
        }
    }

    static interface ParameterValueExtractor {
        public Object extract(String var1, Map<String, String> var2, Map<String, String> var3);
    }
}

