/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.grid.layout;

import org.teamapps.dto.UiGridRow;
import org.teamapps.ux.component.format.SizingPolicy;

public class GridRow {
    private SizingPolicy heightPolicy;
    private int topPadding;
    private int bottomPadding;

    public GridRow() {
        this.heightPolicy = SizingPolicy.AUTO;
    }

    public GridRow(SizingPolicy heightPolicy) {
        this.heightPolicy = heightPolicy;
    }

    public GridRow(SizingPolicy heightPolicy, int topPadding, int bottomPadding) {
        this.heightPolicy = heightPolicy;
        this.topPadding = topPadding;
        this.bottomPadding = bottomPadding;
    }

    public GridRow(GridRow gridRow) {
        this(gridRow.heightPolicy, gridRow.topPadding, gridRow.bottomPadding);
    }

    public SizingPolicy getHeightPolicy() {
        return this.heightPolicy;
    }

    public GridRow setHeightPolicy(SizingPolicy heightPolicy) {
        this.heightPolicy = heightPolicy;
        return this;
    }

    public int getTopPadding() {
        return this.topPadding;
    }

    public GridRow setTopPadding(int topPadding) {
        this.topPadding = topPadding;
        return this;
    }

    public int getBottomPadding() {
        return this.bottomPadding;
    }

    public GridRow setBottomPadding(int bottomPadding) {
        this.bottomPadding = bottomPadding;
        return this;
    }

    public UiGridRow createUiGridRow() {
        return new UiGridRow().setHeightPolicy(this.heightPolicy != null ? this.heightPolicy.createUiSizingPolicy() : null).setTopPadding(this.topPadding).setBottomPadding(this.bottomPadding);
    }
}

