/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.TimePartitioning;
import org.teamapps.ux.component.timegraph.TimePartitioningUnit;
import org.teamapps.ux.component.timegraph.datapoints.LineGraphData;
import org.teamapps.ux.component.timegraph.datapoints.LineGraphDataPoint;
import org.teamapps.ux.component.timegraph.datapoints.ListLineGraphData;
import org.teamapps.ux.component.timegraph.model.AggregatingLineGraphModel;
import org.teamapps.ux.component.timegraph.model.AggregationType;

public class AggregatingTimeGraphModelTest {
    private AggregatingLineGraphModel model;

    @Before
    public void setUp() throws Exception {
        this.model = new AggregatingLineGraphModel();
        this.model.setGraphData((LineGraphData)new ListLineGraphData(Arrays.asList(new LineGraphDataPoint(100.0, 1.0), new LineGraphDataPoint(200.0, 11.0), new LineGraphDataPoint(300.0, 2.0), new LineGraphDataPoint(405.0, 0.0), new LineGraphDataPoint(500.0, 13.0), new LineGraphDataPoint(600.0, 12.0), new LineGraphDataPoint(700.0, 3.0)), new Interval(100L, 800L)));
    }

    @Test
    public void testFirstValue() throws Exception {
        this.model.setAggregationPolicy(AggregationType.FIRST_VALUE);
        this.model.setAddDataPointBeforeAndAfterQueryResult(false);
        List dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.YEAR, (ZoneId)ZoneOffset.UTC, new Interval(0L, 1000L), new Interval(0L, 1000L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(0.0, 1.0)});
        dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.MILLISECOND_200, (ZoneId)ZoneOffset.UTC, new Interval(200L, 350L), new Interval(200L, 350L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(200.0, 11.0)});
        dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.MILLISECOND_200, (ZoneId)ZoneOffset.UTC, new Interval(300L, 401L), new Interval(300L, 401L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(200.0, 11.0), new LineGraphDataPoint(400.0, 0.0)});
        dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.MILLISECOND_200, (ZoneId)ZoneOffset.UTC, new Interval(500L, 601L), new Interval(500L, 601L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(400.0, 0.0), new LineGraphDataPoint(600.0, 12.0)});
    }

    @Test
    public void testMin() throws Exception {
        this.model.setAggregationPolicy(AggregationType.MIN);
        this.model.setAddDataPointBeforeAndAfterQueryResult(false);
        List dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.YEAR, (ZoneId)ZoneOffset.UTC, new Interval(0L, 1000L), new Interval(0L, 1000L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(0.0, 0.0)});
        dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.MILLISECOND_200, (ZoneId)ZoneOffset.UTC, new Interval(200L, 350L), new Interval(200L, 350L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(200.0, 2.0)});
        dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.MILLISECOND_200, (ZoneId)ZoneOffset.UTC, new Interval(300L, 401L), new Interval(300L, 401L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(200.0, 2.0), new LineGraphDataPoint(400.0, 0.0)});
        dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.MILLISECOND_200, (ZoneId)ZoneOffset.UTC, new Interval(500L, 601L), new Interval(500L, 601L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(400.0, 0.0), new LineGraphDataPoint(600.0, 3.0)});
    }

    @Test
    public void testMax() throws Exception {
        this.model.setAggregationPolicy(AggregationType.MAX);
        this.model.setAddDataPointBeforeAndAfterQueryResult(false);
        List dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.YEAR, (ZoneId)ZoneOffset.UTC, new Interval(0L, 1000L), new Interval(0L, 1000L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(0.0, 13.0)});
        dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.MILLISECOND_200, (ZoneId)ZoneOffset.UTC, new Interval(400L, 550L), new Interval(400L, 550L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(400.0, 13.0)});
        dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.MILLISECOND_200, (ZoneId)ZoneOffset.UTC, new Interval(300L, 500L), new Interval(300L, 500L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(200.0, 11.0), new LineGraphDataPoint(400.0, 13.0)});
        dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.MILLISECOND_200, (ZoneId)ZoneOffset.UTC, new Interval(500L, 700L), new Interval(500L, 700L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(400.0, 13.0), new LineGraphDataPoint(600.0, 12.0)});
    }

    @Test
    public void testAverage() throws Exception {
        this.model.setAggregationPolicy(AggregationType.AVERAGE);
        this.model.setAddDataPointBeforeAndAfterQueryResult(false);
        List dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.YEAR, (ZoneId)ZoneOffset.UTC, new Interval(0L, 1000L), new Interval(0L, 1000L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(0.0, 6.0)});
        dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.MILLISECOND_200, (ZoneId)ZoneOffset.UTC, new Interval(400L, 550L), new Interval(400L, 550L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(400.0, 6.5)});
        dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.MILLISECOND_200, (ZoneId)ZoneOffset.UTC, new Interval(300L, 401L), new Interval(300L, 401L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(200.0, 6.5), new LineGraphDataPoint(400.0, 6.5)});
        dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.MILLISECOND_200, (ZoneId)ZoneOffset.UTC, new Interval(500L, 601L), new Interval(500L, 601L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(400.0, 6.5), new LineGraphDataPoint(600.0, 7.5)});
    }

    @Test
    public void testAddDataPointBeforeAndAfterQueryResult() throws Exception {
        this.model.setAggregationPolicy(AggregationType.FIRST_VALUE);
        this.model.setAddDataPointBeforeAndAfterQueryResult(true);
        List dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.MILLISECOND_200, (ZoneId)ZoneOffset.UTC, new Interval(450L, 550L), new Interval(450L, 550L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(200.0, 11.0), new LineGraphDataPoint(400.0, 0.0), new LineGraphDataPoint(600.0, 12.0)});
        dataPoints = this.model.getData((TimePartitioning)TimePartitioningUnit.MILLISECOND_200, (ZoneId)ZoneOffset.UTC, new Interval(400L, 600L), new Interval(400L, 600L)).streamDataPoints().collect(Collectors.toList());
        Assertions.assertThat(dataPoints).containsExactly((Object[])new LineGraphDataPoint[]{new LineGraphDataPoint(200.0, 11.0), new LineGraphDataPoint(400.0, 0.0), new LineGraphDataPoint(600.0, 12.0)});
    }
}

