/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.uisession.commandbuffer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.uisession.CMD;
import org.teamapps.uisession.commandbuffer.CommandBufferException;
import org.teamapps.uisession.commandbuffer.CommandBufferLengthOverflowException;
import org.teamapps.uisession.commandbuffer.CommandBufferSizeOverflowException;

public class CommandBuffer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandBuffer.class);
    private final int maxFillableCapacity;
    private final int maxTotalSize;
    private final CMD[] buffer;
    private int head = 0;
    private int nextConsumable = 0;
    private int tail = 0;
    private boolean bufferFlippedAtLeastOnce;
    private int totalSize = 0;

    public CommandBuffer(int maxLength, int maxTotalSize) {
        this.maxFillableCapacity = maxLength;
        this.maxTotalSize = maxTotalSize;
        this.buffer = new CMD[this.maxFillableCapacity + 1];
    }

    public int getBufferedCommandsCount() {
        return this.head - this.tail + (this.head < this.tail ? this.buffer.length : 0);
    }

    public int getUnconsumedCommandsCount() {
        return this.head - this.nextConsumable + (this.head < this.nextConsumable ? this.buffer.length : 0);
    }

    public int getCommandsSize() {
        int size = 0;
        for (int i = 0; i < this.buffer.length; ++i) {
            if (this.buffer[i] == null) continue;
            size += this.buffer[i].getUiCommand().length();
        }
        return size;
    }

    public void addCommand(CMD command) throws CommandBufferException {
        while (this.totalSize + command.getUiCommand().length() > this.maxTotalSize) {
            if (this.tryPurgingNextCommandFromTail()) continue;
            throw new CommandBufferSizeOverflowException("Command buffer SIZE overflow. Max total size: " + this.maxTotalSize + " characters");
        }
        if (this.getBufferedCommandsCount() == this.maxFillableCapacity && !this.tryPurgingNextCommandFromTail()) {
            throw new CommandBufferLengthOverflowException("Command buffer LENGTH overflow. Max capacity: " + this.maxFillableCapacity);
        }
        this.buffer[this.head] = command;
        if (this.head + 1 == this.buffer.length) {
            this.bufferFlippedAtLeastOnce = true;
        }
        this.head = (this.head + 1) % this.buffer.length;
        this.totalSize += command.getUiCommand().length();
    }

    public CMD consumeCommand() {
        if (this.getBufferedCommandsCount() > 0 && this.nextConsumable != this.head) {
            CMD command = this.buffer[this.nextConsumable];
            this.nextConsumable = (this.nextConsumable + 1) % this.buffer.length;
            return command;
        }
        return null;
    }

    public void purgeTillCommand(int commandIdExclusive) {
        while (this.buffer[this.tail].getId() != commandIdExclusive) {
            if (this.tryPurgingNextCommandFromTail()) continue;
            LOGGER.error("Will not purge next consumable command!");
            return;
        }
    }

    private boolean tryPurgingNextCommandFromTail() {
        if (this.tail == this.nextConsumable) {
            return false;
        }
        CMD cmd = this.buffer[this.tail];
        this.buffer[this.tail] = null;
        this.tail = (this.tail + 1) % this.buffer.length;
        this.totalSize -= cmd.getUiCommand().length();
        return true;
    }

    public boolean rewindToCommand(long commandId) {
        int i;
        if (commandId == -1L) {
            if (this.bufferFlippedAtLeastOnce) {
                return false;
            }
            this.nextConsumable = 0;
            return true;
        }
        int n = i = this.tail < this.nextConsumable ? this.nextConsumable - 1 : this.nextConsumable + this.buffer.length - 1;
        while (i >= this.tail) {
            CMD command = this.buffer[i % this.buffer.length];
            if (command == null) {
                return false;
            }
            if ((long)command.getId() == commandId) {
                this.nextConsumable = (i + 1) % this.buffer.length;
                return true;
            }
            --i;
        }
        return false;
    }

    public long getNextCommandId() {
        return this.buffer[this.nextConsumable].getId();
    }

    public void clear() {
        this.head = 0;
        this.nextConsumable = 0;
        this.tail = 0;
    }
}

