/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application.layout;

import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutViewGroup;
import org.teamapps.ux.component.workspacelayout.definition.ViewGroupDefinition;

public class ComponentPosition {
    private String layoutPosition;
    private boolean window;
    private boolean modalWindow;
    private float width;
    private float height;
    private int minWidth;
    private int minHeight;
    private String animation;

    public static ComponentPosition asPanel(WorkSpaceLayoutViewGroup viewGroup) {
        return new ComponentPosition(viewGroup.getId());
    }

    public static ComponentPosition asPanel(ViewGroupDefinition viewGroup) {
        return new ComponentPosition(viewGroup.getId());
    }

    public static ComponentPosition asPanel(String layoutPosition) {
        return new ComponentPosition(layoutPosition);
    }

    public static ComponentPosition asPanel(String layoutPosition, float width, float height, int minWidth, int minHeight) {
        return new ComponentPosition(layoutPosition).setWidth(width).setHeight(height).setMinWidth(minWidth).setMinHeight(minHeight);
    }

    public static ComponentPosition asWindow(float width, float height) {
        return new ComponentPosition(width, height);
    }

    public static ComponentPosition asWindow(float width, float height, int minWidth, int minHeight) {
        return new ComponentPosition(width, height, minWidth, minHeight);
    }

    public static ComponentPosition asWindow(float width, float height, int minWidth, int minHeight, boolean modal) {
        return new ComponentPosition(width, height, minWidth, minHeight).setModalWindow(modal);
    }

    public static ComponentPosition asWindowMaxSize() {
        return new ComponentPosition(0.9f, 0.9f);
    }

    public static ComponentPosition asWindowStandardSize() {
        return new ComponentPosition(0.5f, 0.5f, 800, 600);
    }

    public static ComponentPosition asWindowSmallSize() {
        return new ComponentPosition(0.35f, 0.35f);
    }

    public static ComponentPosition asWindowNarrowSize() {
        return new ComponentPosition(0.9f, 0.5f);
    }

    public static ComponentPosition asWindowWideSize() {
        return new ComponentPosition(0.9f, 0.9f);
    }

    public ComponentPosition(String layoutPosition) {
        this.layoutPosition = layoutPosition;
    }

    public ComponentPosition(String layoutPosition, float width, float height, int minWidth, int minHeight) {
        this.layoutPosition = layoutPosition;
        this.width = width;
        this.height = height;
        this.minWidth = minWidth;
        this.minHeight = minHeight;
    }

    public ComponentPosition(float width, float height) {
        this.window = true;
        this.width = width;
        this.height = height;
    }

    public ComponentPosition(float width, float height, int minWidth, int minHeight) {
        this.window = true;
        this.width = width;
        this.height = height;
        this.minWidth = minWidth;
        this.minHeight = minHeight;
    }

    public ComponentPosition setModalWindow(boolean modalWindow) {
        this.modalWindow = modalWindow;
        return this;
    }

    public ComponentPosition setAnimation(String animation) {
        this.animation = animation;
        return this;
    }

    public ComponentPosition setWidth(float width) {
        this.width = width;
        return this;
    }

    public ComponentPosition setHeight(float height) {
        this.height = height;
        return this;
    }

    public ComponentPosition setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    public ComponentPosition setMinHeight(int minHeight) {
        this.minHeight = minHeight;
        return this;
    }

    public String getLayoutPosition() {
        return this.layoutPosition;
    }

    public boolean isWindow() {
        return this.window;
    }

    public boolean isModalWindow() {
        return this.modalWindow;
    }

    public String getAnimation() {
        return this.animation;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public int getMinHeight() {
        return this.minHeight;
    }
}

