/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.datetime;

import com.ibm.icu.util.ULocale;
import java.time.LocalDate;
import java.util.Locale;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiLocalDate;
import org.teamapps.dto.UiLocalDateField;
import org.teamapps.event.Event;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.SpecialKey;
import org.teamapps.ux.component.field.TextInputHandlingField;
import org.teamapps.ux.session.DateTimeFormatDescriptor;

public class LocalDateField
extends AbstractField<LocalDate>
implements TextInputHandlingField {
    public final Event<String> onTextInput = new Event();
    public final Event<SpecialKey> onSpecialKeyPressed = new Event();
    private boolean showDropDownButton = true;
    private boolean showClearButton = false;
    private boolean favorPastDates = false;
    private ULocale locale;
    private DateTimeFormatDescriptor dateFormat;
    private LocalDate defaultSuggestionDate;
    private boolean shuffledFormatSuggestionsEnabled = false;
    private DropDownMode dropDownMode = DropDownMode.CALENDAR_SUGGESTION_LIST;
    private String emptyText;

    public LocalDateField() {
        this.locale = this.getSessionContext().getULocale();
        this.dateFormat = this.getSessionContext().getConfiguration().getDateFormat();
    }

    public UiLocalDateField createUiComponent() {
        UiLocalDateField dateField = new UiLocalDateField();
        this.mapAbstractFieldAttributesToUiField((UiField)dateField);
        dateField.setShowDropDownButton(this.showDropDownButton);
        dateField.setFavorPastDates(this.favorPastDates);
        dateField.setLocale(this.locale.toLanguageTag());
        dateField.setDateFormat(this.dateFormat.toDateTimeFormatDescriptor());
        dateField.setShowClearButton(this.showClearButton);
        dateField.setDefaultSuggestionDate(this.convertUxValueToUiValue(this.defaultSuggestionDate));
        dateField.setShuffledFormatSuggestionsEnabled(this.shuffledFormatSuggestionsEnabled);
        dateField.setDropDownMode(UiLocalDateField.DropDownMode.valueOf((String)this.dropDownMode.name()));
        dateField.setPlaceholderText(this.emptyText);
        return dateField;
    }

    @Override
    public LocalDate convertUiValueToUxValue(Object value) {
        if (value == null) {
            return null;
        }
        UiLocalDate uiLocalDate = (UiLocalDate)value;
        return LocalDate.of(uiLocalDate.getYear(), uiLocalDate.getMonth(), uiLocalDate.getDay());
    }

    public UiLocalDate convertUxValueToUiValue(LocalDate localDate) {
        return localDate != null ? new UiLocalDate(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth()) : null;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        this.defaultHandleTextInputEvent(event);
    }

    public boolean isShowDropDownButton() {
        return this.showDropDownButton;
    }

    public void setShowDropDownButton(boolean showDropDownButton) {
        this.showDropDownButton = showDropDownButton;
        this.queueCommandIfRendered(() -> new UiLocalDateField.UpdateCommand(this.getId(), this.createUiComponent()));
    }

    public boolean isFavorPastDates() {
        return this.favorPastDates;
    }

    public void setFavorPastDates(boolean favorPastDates) {
        this.favorPastDates = favorPastDates;
        this.queueCommandIfRendered(() -> new UiLocalDateField.UpdateCommand(this.getId(), this.createUiComponent()));
    }

    public Locale getLocale() {
        return this.locale.toLocale();
    }

    public ULocale getULocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.setULocale(ULocale.forLocale((Locale)locale));
    }

    public void setULocale(ULocale locale) {
        this.locale = locale;
        this.queueCommandIfRendered(() -> new UiLocalDateField.UpdateCommand(this.getId(), this.createUiComponent()));
    }

    public DateTimeFormatDescriptor getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateTimeFormatDescriptor dateFormat) {
        this.dateFormat = dateFormat;
        this.queueCommandIfRendered(() -> new UiLocalDateField.UpdateCommand(this.getId(), this.createUiComponent()));
    }

    public boolean isShowClearButton() {
        return this.showClearButton;
    }

    public void setShowClearButton(boolean showClearButton) {
        this.showClearButton = showClearButton;
        this.queueCommandIfRendered(() -> new UiLocalDateField.UpdateCommand(this.getId(), this.createUiComponent()));
    }

    @Override
    public Event<String> onTextInput() {
        return this.onTextInput;
    }

    @Override
    public Event<SpecialKey> onSpecialKeyPressed() {
        return this.onSpecialKeyPressed;
    }

    public LocalDate getDefaultSuggestionDate() {
        return this.defaultSuggestionDate;
    }

    public void setDefaultSuggestionDate(LocalDate defaultSuggestionDate) {
        this.defaultSuggestionDate = defaultSuggestionDate;
        this.queueCommandIfRendered(() -> new UiLocalDateField.UpdateCommand(this.getId(), this.createUiComponent()));
    }

    public boolean isShuffledFormatSuggestionsEnabled() {
        return this.shuffledFormatSuggestionsEnabled;
    }

    public void setShuffledFormatSuggestionsEnabled(boolean shuffledFormatSuggestionsEnabled) {
        this.shuffledFormatSuggestionsEnabled = shuffledFormatSuggestionsEnabled;
        this.queueCommandIfRendered(() -> new UiLocalDateField.UpdateCommand(this.getId(), this.createUiComponent()));
    }

    public DropDownMode getDropDownMode() {
        return this.dropDownMode;
    }

    public void setDropDownMode(DropDownMode dropDownMode) {
        this.dropDownMode = dropDownMode;
        this.queueCommandIfRendered(() -> new UiLocalDateField.UpdateCommand(this.getId(), this.createUiComponent()));
    }

    public String getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(String emptyText) {
        this.emptyText = emptyText;
        this.queueCommandIfRendered(() -> new UiLocalDateField.UpdateCommand(this.getId(), this.createUiComponent()));
    }

    public static enum DropDownMode {
        CALENDAR,
        CALENDAR_SUGGESTION_LIST,
        SUGGESTION_LIST;

    }
}

