/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.multicurrency.value;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.teamapps.dto.UiCurrencyValue;
import org.teamapps.ux.component.field.multicurrency.value.CurrencyUnit;

public class CurrencyValue {
    private final CurrencyUnit currency;
    private final BigDecimal amount;

    public CurrencyValue(CurrencyUnit currency, BigDecimal amount) {
        this.currency = currency;
        this.amount = amount;
    }

    public Optional<CurrencyUnit> getCurrency() {
        return Optional.ofNullable(this.currency);
    }

    public Optional<BigDecimal> getAmount() {
        return Optional.ofNullable(this.amount);
    }

    public Optional<Long> getAmountAsLong(int pointRightShift) {
        return this.getAmount().map(amount -> amount.movePointRight(pointRightShift).longValue());
    }

    public CurrencyValue withAmount(BigDecimal amount) {
        return new CurrencyValue(this.currency, amount);
    }

    public CurrencyValue withCurrencyUnit(CurrencyUnit currencyUnit) {
        return new CurrencyValue(currencyUnit, this.amount);
    }

    public UiCurrencyValue toUiCurrencyValue(Locale locale) {
        return new UiCurrencyValue(this.currency != null ? this.currency.toUiCurrencyUnit(locale) : null, this.amount != null ? this.amount.toString() : null);
    }

    public String toString() {
        return "CurrencyValue{currency=" + this.currency + ", amount=" + this.amount + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrencyValue that = (CurrencyValue)o;
        return Objects.equals(this.currency, that.currency) && Objects.equals(this.amount, that.amount);
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.amount);
    }
}

