/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.infiniteitemview;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.teamapps.ux.cache.record.ItemRange;

public class RecordsChangedEvent<RECORD> {
    private final ItemRange itemRange;
    private final List<RECORD> records;

    public RecordsChangedEvent(ItemRange itemRange) {
        this.itemRange = itemRange;
        this.records = null;
    }

    public RecordsChangedEvent(int startIndex, List<RECORD> records) {
        Objects.requireNonNull(records);
        this.itemRange = ItemRange.startLength(startIndex, records.size());
        this.records = records;
    }

    public ItemRange getItemRange() {
        return this.itemRange;
    }

    public Optional<List<RECORD>> getRecords() {
        return Optional.ofNullable(this.records);
    }

    public int getStart() {
        return this.getItemRange().getStart();
    }

    public int getLength() {
        return this.getItemRange().getLength();
    }

    public int getEnd() {
        return this.getItemRange().getEnd();
    }
}

