/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.map.shape;

import java.util.UUID;
import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.dto.AbstractUiMapShape;
import org.teamapps.dto.AbstractUiMapShapeChange;
import org.teamapps.ux.component.map.shape.ShapeProperties;

public abstract class AbstractMapShape {
    protected String clientId = UUID.randomUUID().toString();
    protected final ShapeProperties properties;
    protected MapShapeListener listener;

    public AbstractMapShape() {
        this(new ShapeProperties((Color)RgbaColor.BLUE));
    }

    public AbstractMapShape(ShapeProperties properties) {
        this.properties = properties;
    }

    public abstract AbstractUiMapShape createUiMapShape();

    protected void mapAbstractUiShapeProperties(AbstractUiMapShape uiShape) {
        uiShape.setShapeProperties(this.properties.createUiShapeProperties());
    }

    public ShapeProperties getProperties() {
        return this.properties;
    }

    public void remove() {
        this.listener.handleShapeRemoved(this);
    }

    public void setListenerInternal(MapShapeListener listener) {
        this.listener = listener;
    }

    public String getClientIdInternal() {
        return this.clientId;
    }

    public void setClientIdInternal(String clientId) {
        this.clientId = clientId;
    }

    public static interface MapShapeListener {
        public void handleShapeChanged(AbstractMapShape var1);

        public void handleShapeChanged(AbstractMapShape var1, AbstractUiMapShapeChange var2);

        public void handleShapeRemoved(AbstractMapShape var1);
    }
}

