/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.map.shape;

import org.teamapps.common.format.Color;
import org.teamapps.dto.AbstractUiMapShape;
import org.teamapps.dto.UiMapCircle;
import org.teamapps.ux.component.map.Location;
import org.teamapps.ux.component.map.shape.AbstractMapShape;
import org.teamapps.ux.component.map.shape.ShapeProperties;

public class MapCircle
extends AbstractMapShape {
    private Location center;
    private int radiusMeters;

    public MapCircle(Location center, int radiusMeters) {
        this.center = center;
        this.radiusMeters = radiusMeters;
    }

    public MapCircle(Location center, int radiusMeters, ShapeProperties properties) {
        super(properties);
        this.center = center;
        this.radiusMeters = radiusMeters;
    }

    public MapCircle(Location center, int radiusMeters, Color fillColor) {
        this(center, radiusMeters, new ShapeProperties((Color)Color.TRANSPARENT, 0.0f, fillColor));
        this.center = center;
        this.radiusMeters = radiusMeters;
    }

    public MapCircle(Location center, int radiusMeters, Color fillColor, Color strokeColor) {
        this(center, radiusMeters, new ShapeProperties(strokeColor, 1.0f, fillColor));
    }

    public MapCircle(Location center, int radiusMeters, Color fillColor, Color strokeColor, float strokeWidth) {
        this(center, radiusMeters, new ShapeProperties(strokeColor, strokeWidth, fillColor));
    }

    public UiMapCircle createUiMapShape() {
        UiMapCircle uiCircle = new UiMapCircle();
        this.mapAbstractUiShapeProperties((AbstractUiMapShape)uiCircle);
        uiCircle.setCenter(this.center.createUiLocation());
        uiCircle.setRadius(this.radiusMeters);
        return uiCircle;
    }

    public Location getCenter() {
        return this.center;
    }

    public void setCenter(Location center) {
        this.center = center;
        this.listener.handleShapeChanged(this);
    }

    public int getRadiusMeters() {
        return this.radiusMeters;
    }

    public void setRadiusMeters(int radiusMeters) {
        this.radiusMeters = radiusMeters;
        this.listener.handleShapeChanged(this);
    }
}

