/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.progress;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiDefaultMultiProgressDisplay;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiMultiProgressDisplay;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.field.DisplayField;
import org.teamapps.ux.component.flexcontainer.VerticalLayout;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.notification.Notification;
import org.teamapps.ux.component.notification.NotificationPosition;
import org.teamapps.ux.component.progress.MultiProgressDisplay;
import org.teamapps.ux.component.progress.ProgressDisplay;
import org.teamapps.ux.i18n.TeamAppsDictionary;
import org.teamapps.ux.task.ObservableProgress;
import org.teamapps.ux.task.ProgressCompletableFuture;
import org.teamapps.ux.task.ProgressStatus;

public class DefaultMultiProgressDisplay
extends AbstractComponent
implements MultiProgressDisplay {
    public final Event<Void> onClicked = new Event();
    private final List<ObservableProgress> progresses = new ArrayList<ObservableProgress>();
    private final Notification progressListNotification;
    private final VerticalLayout progressListVerticalLayout;
    private final DisplayField noEntriesDisplayField;
    private boolean showNotificationOnProgressAdded = true;
    private int notificationDisplayTimeMillis = 3000;
    private final NotificationPosition notificationPosition = NotificationPosition.BOTTOM_RIGHT;
    private int listEntryRemainTimeout = 5000;
    private boolean showingNotificationWithoutTimeout = false;

    public DefaultMultiProgressDisplay() {
        this.progressListVerticalLayout = new VerticalLayout();
        this.noEntriesDisplayField = new DisplayField();
        this.noEntriesDisplayField.setValue("<div style=\"text-align: center\">" + this.getSessionContext().getLocalized(TeamAppsDictionary.NO_RUNNING_TASKS.getKey(), new Object[0]) + "</div>");
        this.noEntriesDisplayField.setShowHtml(true);
        this.progressListVerticalLayout.addComponent(this.noEntriesDisplayField);
        this.progressListNotification = new Notification(this.progressListVerticalLayout);
        this.progressListNotification.setPadding(new Spacing(2, 4, 2, 4));
        this.progressListNotification.setShowProgressBar(false);
        this.progressListNotification.onClosed.addListener(byUser -> {
            this.showingNotificationWithoutTimeout = false;
        });
    }

    public UiDefaultMultiProgressDisplay createUiComponent() {
        UiDefaultMultiProgressDisplay ui = new UiDefaultMultiProgressDisplay();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setRunningCount(this.progresses.size());
        ui.setStatusMessages(this.progresses.stream().map(p -> p.getStatusMessage()).collect(Collectors.toList()));
        return ui;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_MULTI_PROGRESS_DISPLAY_CLICKED: {
                this.onClicked.fire(null);
                if (this.showingNotificationWithoutTimeout) {
                    this.showingNotificationWithoutTimeout = false;
                    this.progressListNotification.close();
                    break;
                }
                this.showingNotificationWithoutTimeout = true;
                if (this.progresses.size() > 0) {
                    this.progressListNotification.setDisplayTimeInMillis(-1);
                } else {
                    this.progressListNotification.setDisplayTimeInMillis(2000);
                }
                this.getSessionContext().showNotification(this.progressListNotification, this.notificationPosition);
            }
        }
    }

    @Override
    public void addProgress(Icon icon, String taskName, ObservableProgress progress) {
        this.progresses.add(progress);
        this.progressListVerticalLayout.removeComponent(this.noEntriesDisplayField);
        ProgressDisplay progressDisplay = new ProgressDisplay(icon, taskName, progress);
        progressDisplay.setMargin(new Spacing(2, 0, 2, 0));
        this.progressListVerticalLayout.addComponent(progressDisplay);
        progress.onChanged().addListener(data -> {
            if (EnumSet.of(ProgressStatus.CANCELED, ProgressStatus.COMPLETE, ProgressStatus.FAILED).contains((Object)data.getStatus())) {
                this.showNotificationDueToUpdate();
                this.progresses.remove(progress);
                this.update();
                ((ProgressCompletableFuture)new ProgressCompletableFuture().completeOnTimeout((Object)null, (long)this.listEntryRemainTimeout, TimeUnit.MILLISECONDS)).handleWithCurrentSessionContext((aVoid, throwable) -> {
                    this.progressListVerticalLayout.removeComponent(progressDisplay);
                    if (this.progressListVerticalLayout.getComponents().size() == 0) {
                        this.progressListVerticalLayout.addComponent(this.noEntriesDisplayField);
                    }
                    if (this.progresses.size() == 0) {
                        this.showingNotificationWithoutTimeout = false;
                        this.progressListNotification.close();
                    }
                    return null;
                });
            }
        });
        this.showNotificationDueToUpdate();
        this.update();
    }

    private void showNotificationDueToUpdate() {
        if (!this.showingNotificationWithoutTimeout) {
            this.progressListNotification.setDisplayTimeInMillis(this.notificationDisplayTimeMillis);
            this.getSessionContext().showNotification(this.progressListNotification, this.notificationPosition);
        }
    }

    private void update() {
        this.queueCommandIfRendered(() -> new UiMultiProgressDisplay.UpdateCommand(this.getId(), this.createUiComponent()));
    }

    public boolean isShowNotificationOnProgressAdded() {
        return this.showNotificationOnProgressAdded;
    }

    public void setShowNotificationOnProgressAdded(boolean showNotificationOnProgressAdded) {
        this.showNotificationOnProgressAdded = showNotificationOnProgressAdded;
    }

    public int getNotificationDisplayTimeMillis() {
        return this.notificationDisplayTimeMillis;
    }

    public void setNotificationDisplayTimeMillis(int notificationDisplayTimeMillis) {
        this.notificationDisplayTimeMillis = notificationDisplayTimeMillis;
    }

    public int getListEntryRemainTimeout() {
        return this.listEntryRemainTimeout;
    }

    public void setListEntryRemainTimeout(int listEntryRemainTimeout) {
        this.listEntryRemainTimeout = listEntryRemainTimeout;
    }
}

