/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.template.gridtemplate;

import org.teamapps.common.format.Color;
import org.teamapps.dto.AbstractUiTemplateElement;
import org.teamapps.dto.UiTextElement;
import org.teamapps.ux.component.format.FontStyle;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.format.TextAlignment;
import org.teamapps.ux.component.format.VerticalElementAlignment;
import org.teamapps.ux.component.template.gridtemplate.AbstractTemplateElement;

public class TextElement
extends AbstractTemplateElement<TextElement> {
    protected FontStyle fontStyle;
    protected float lineHeight = 1.2f;
    protected boolean wrapLines;
    protected Spacing padding;
    protected TextAlignment textAlignment = TextAlignment.LEFT;

    public TextElement(String propertyName) {
        super(propertyName);
    }

    public TextElement(String propertyName, int row, int column) {
        super(propertyName, row, column);
    }

    public TextElement(String propertyName, int row, int column, int rowSpan, int colSpan) {
        super(propertyName, row, column, rowSpan, colSpan);
    }

    public TextElement(String propertyName, int row, int column, int rowSpan, int colSpan, HorizontalElementAlignment horizontalAlignment, VerticalElementAlignment verticalAlignment) {
        super(propertyName, row, column, rowSpan, colSpan, horizontalAlignment, verticalAlignment);
    }

    @Override
    public AbstractUiTemplateElement createUiTemplateElement() {
        UiTextElement uiTextElement = new UiTextElement(this.propertyName, this.row, this.column);
        this.mapAbstractTemplateElementAttributesToUiElement((AbstractUiTemplateElement)uiTextElement);
        this.mapTextElementAttributesToUiElement(uiTextElement);
        return uiTextElement;
    }

    protected void mapTextElementAttributesToUiElement(UiTextElement uiTextElement) {
        uiTextElement.setFontStyle(this.fontStyle != null ? this.fontStyle.createUiFontStyle() : null);
        uiTextElement.setLineHeight(this.lineHeight);
        uiTextElement.setWrapLines(this.wrapLines);
        uiTextElement.setPadding(this.padding != null ? this.padding.createUiSpacing() : null);
        uiTextElement.setTextAlignment(this.textAlignment.toUiTextAlignment());
    }

    public String getProperty() {
        return this.propertyName;
    }

    public TextElement setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
        return this;
    }

    public TextElement setFontStyle(float relativeFontSize) {
        this.fontStyle = new FontStyle(relativeFontSize);
        return this;
    }

    public TextElement setFontStyle(float relativeFontSize, Color fontColor) {
        this.fontStyle = new FontStyle(relativeFontSize, fontColor);
        return this;
    }

    public TextElement setLineHeight(float lineHeight) {
        this.lineHeight = lineHeight;
        return this;
    }

    public TextElement setWrapLines(boolean wrapLines) {
        this.wrapLines = wrapLines;
        return this;
    }

    public TextElement setPadding(Spacing padding) {
        this.padding = padding;
        return this;
    }

    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    public float getLineHeight() {
        return this.lineHeight;
    }

    public boolean isWrapLines() {
        return this.wrapLines;
    }

    public Spacing getPadding() {
        return this.padding;
    }

    public TextAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public TextElement setTextAlignment(TextAlignment textAlignment) {
        this.textAlignment = textAlignment;
        return this;
    }
}

