/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import jakarta.inject.Inject;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.glassfish.jersey.internal.inject.ParamConverters;

public class ParameterConverterProvider
implements ParamConverterProvider {
    private final List<ParamConverterProvider> providers = new ArrayList<ListParamConverterProvider>(List.of(new ParamConverters.DateProvider(), new ParamConverters.TypeFromStringEnum(), new ParamConverters.TypeValueOf(), new ParamConverters.CharacterProvider(), new ParamConverters.TypeFromString(), new ParamConverters.StringConstructor(), new ParamConverters.OptionalProvider(), new ListParamConverterProvider()));

    @Inject
    public ParameterConverterProvider() {
    }

    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        for (ParamConverterProvider p : this.providers) {
            ParamConverter reader = p.getConverter(rawType, genericType, annotations);
            if (reader == null) continue;
            return reader;
        }
        return null;
    }

    public void addConverterProvider(ParamConverterProvider converterProvider) {
        this.providers.add(0, converterProvider);
    }

    public <T> void addConverter(final Class<T> clazz, final ParamConverter<T> converter) {
        this.providers.add(0, new ParameterConverterProvider(){

            public <X> ParamConverter<X> getConverter(Class<X> rawType, Type genericType, Annotation[] annotations) {
                if (rawType == clazz) {
                    return converter;
                }
                return null;
            }
        });
    }

    private class ListValuedParamConverter
    implements ParamConverter<List<?>> {
        private final ParamConverter<?> itemConverter;

        public ListValuedParamConverter(Type parameterType) {
            this.itemConverter = ParameterConverterProvider.this.getConverter((Class)parameterType, parameterType, null);
        }

        public List<?> fromString(String param) {
            if (param == null || param.trim().isEmpty()) {
                return null;
            }
            return Arrays.stream(param.split(",")).map(s -> this.itemConverter.fromString(s)).collect(Collectors.toList());
        }

        public String toString(List<?> list) {
            if (list == null || list.isEmpty()) {
                return null;
            }
            return list.stream().map(item -> this.itemConverter.toString(item)).collect(Collectors.joining(","));
        }
    }

    private class ListParamConverterProvider
    implements ParamConverterProvider {
        private ListParamConverterProvider() {
        }

        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            if (!List.class.isAssignableFrom(rawType)) {
                return null;
            }
            if (genericType instanceof ParameterizedType) {
                Type parameterType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                return new ListValuedParamConverter(parameterType);
            }
            return null;
        }
    }
}

