/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.dto.UiField;
import org.teamapps.dto.UiImageField;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.format.Border;
import org.teamapps.ux.component.format.ImageSizing;

public class ImageField
extends AbstractField<String> {
    private int width;
    private int height;
    private Border border;
    private ImageSizing imageSizing = ImageSizing.CONTAIN;

    public UiField createUiComponent() {
        UiImageField uiImageField = new UiImageField();
        this.mapAbstractFieldAttributesToUiField((UiField)uiImageField);
        uiImageField.setWidth(this.width);
        uiImageField.setHeight(this.height);
        uiImageField.setBorder(this.border != null ? this.border.createUiBorder() : null);
        uiImageField.setImageSizing(this.imageSizing.toUiImageSizing());
        return uiImageField;
    }

    @Override
    protected void doDestroy() {
    }

    public int getWidth() {
        return this.width;
    }

    public ImageField setWidth(int width) {
        this.width = width;
        this.queueCommandIfRendered(() -> new UiImageField.SetSizeCommand(this.getId(), width, this.height));
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public ImageField setHeight(int height) {
        this.height = height;
        this.queueCommandIfRendered(() -> new UiImageField.SetSizeCommand(this.getId(), this.width, height));
        return this;
    }

    public Border getBorder() {
        return this.border;
    }

    public ImageField setBorder(Border border) {
        this.border = border;
        this.queueCommandIfRendered(() -> new UiImageField.SetBorderCommand(this.getId(), border != null ? border.createUiBorder() : null));
        return this;
    }

    public ImageSizing getImageSizing() {
        return this.imageSizing;
    }

    public ImageField setImageSizing(ImageSizing imageSizing) {
        this.imageSizing = imageSizing;
        this.queueCommandIfRendered(() -> new UiImageField.SetImageSizingCommand(this.getId(), imageSizing.toUiImageSizing()));
        return this;
    }
}

