/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.upload;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiPictureChooser;
import org.teamapps.event.Event;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.Button;
import org.teamapps.ux.component.field.upload.UploadCanceledEventData;
import org.teamapps.ux.component.field.upload.UploadFailedEventData;
import org.teamapps.ux.component.field.upload.UploadStartedEventData;
import org.teamapps.ux.component.field.upload.UploadTooLargeEventData;
import org.teamapps.ux.component.field.upload.UploadedFile;
import org.teamapps.ux.component.field.upload.UploadedFileAccessException;
import org.teamapps.ux.component.flexcontainer.HorizontalLayout;
import org.teamapps.ux.component.flexcontainer.VerticalLayout;
import org.teamapps.ux.component.imagecropper.ImageCropper;
import org.teamapps.ux.component.imagecropper.ImageCropperSelection;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.window.Window;
import org.teamapps.ux.css.CssJustifyContent;
import org.teamapps.ux.resource.FileResource;
import org.teamapps.ux.resource.Resource;

public class PictureChooser
extends AbstractField<Resource> {
    public final Event<UploadTooLargeEventData> onUploadTooLarge = new Event();
    public final Event<UploadStartedEventData> onUploadStarted = new Event();
    public final Event<UploadCanceledEventData> onUploadCanceled = new Event();
    public final Event<UploadFailedEventData> onUploadFailed = new Event();
    public final Event<UploadedFile> onUploadSuccessful = new Event();
    private long maxFileSize = 10000000L;
    private String uploadUrl = "/upload";
    private String fileTooLargeMessage;
    private String uploadErrorMessage;
    private Icon browseButtonIcon = MaterialIcon.EDIT;
    private Icon deleteButtonIcon = MaterialIcon.DELETE;
    private int targetImageWidth = 240;
    private int targetImageHeight = 288;
    private int imageDisplayWidth = -1;
    private int imageDisplayHeight = -1;
    private ImageCropper imageCropper;
    private Window imageCropperWindow;
    private UploadedFile uploadedFile;
    private ImageCropperConverter imageCropperConverter = this::cropAndConvertImage;

    public PictureChooser() {
        this.imageCropper = new ImageCropper();
        this.imageCropper.setAspectRatio(Float.valueOf((float)this.targetImageWidth / (float)this.targetImageHeight));
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.addComponentFillRemaining(this.imageCropper);
        Button<BaseTemplateRecord> cancelButton = Button.create(this.getSessionContext().getLocalized("dict.cancel", new Object[0]));
        cancelButton.setCssStyle("margin-right", "5px");
        Button<BaseTemplateRecord> okButton = Button.create(this.getSessionContext().getLocalized("dict.ok", new Object[0]));
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.addComponentAutoSize(cancelButton);
        horizontalLayout.addComponentAutoSize(okButton);
        horizontalLayout.setJustifyContent(CssJustifyContent.FLEX_END);
        horizontalLayout.setCssStyle("padding", "5px");
        verticalLayout.addComponentAutoSize(horizontalLayout);
        this.imageCropperWindow = new Window((Icon)MaterialIcon.IMAGE, this.getSessionContext().getLocalized("ux.pictureChooser.cropImageWindowTitle", new Object[0]), 600, 400, verticalLayout);
        this.imageCropperWindow.setCloseable(true);
        this.imageCropperWindow.setModal(true);
        this.imageCropperWindow.setCloseOnEscape(true);
        okButton.onValueChanged.addListener(aBoolean -> {
            try {
                ImageCropperSelection selection = this.imageCropper.getSelection();
                Resource converted = this.imageCropperConverter.convert(this.uploadedFile, selection, this.targetImageWidth, this.targetImageHeight);
                this.setValue(converted);
                this.onValueChanged.fire(converted);
                this.imageCropperWindow.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        cancelButton.onValueChanged.addListener(aBoolean -> this.imageCropperWindow.close());
        this.fileTooLargeMessage = this.getSessionContext().getLocalized("ux.fileField.fileTooLarge_short", new Object[0]);
        this.uploadErrorMessage = this.getSessionContext().getLocalized("ux.fileField.uploadError_short", new Object[0]);
    }

    @Override
    public Object convertUxValueToUiValue(Resource resource) {
        return this.getSessionContext().createResourceLink(resource);
    }

    private Resource cropAndConvertImage(UploadedFile uploadedFile, ImageCropperSelection selection, int targetWidth, int targetHeight) throws IOException {
        BufferedImage image = ImageIO.read(uploadedFile.getAsInputStream());
        BufferedImage subImage = image.getSubimage(selection.getLeft(), selection.getTop(), selection.getWidth(), selection.getHeight());
        BufferedImage resultImage = new BufferedImage(targetWidth, targetHeight, 1);
        resultImage.createGraphics().drawImage(subImage.getScaledInstance(targetWidth, targetHeight, 4), 0, 0, null);
        Path tempFile = Files.createTempFile("cropped-image", ".png", new FileAttribute[0]);
        ImageIO.write((RenderedImage)resultImage, "jpg", tempFile.toFile());
        return new FileResource(tempFile.toFile());
    }

    public UiField createUiComponent() {
        UiPictureChooser uiField = new UiPictureChooser();
        this.mapAbstractFieldAttributesToUiField((UiField)uiField);
        uiField.setUploadUrl(this.uploadUrl);
        uiField.setMaxFileSize(this.maxFileSize);
        uiField.setFileTooLargeMessage(this.fileTooLargeMessage);
        uiField.setUploadErrorMessage(this.uploadErrorMessage);
        uiField.setBrowseButtonIcon(this.getSessionContext().resolveIcon(this.browseButtonIcon));
        uiField.setDeleteButtonIcon(this.getSessionContext().resolveIcon(this.deleteButtonIcon));
        uiField.setImageDisplayWidth(this.imageDisplayWidth != -1 ? this.imageDisplayWidth : this.targetImageWidth);
        uiField.setImageDisplayHeight(this.imageDisplayHeight != -1 ? this.imageDisplayHeight : this.targetImageHeight);
        return uiField;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        switch (event.getUiEventType()) {
            case UI_PICTURE_CHOOSER_UPLOAD_TOO_LARGE: {
                UiPictureChooser.UploadTooLargeEvent tooLargeEvent = (UiPictureChooser.UploadTooLargeEvent)event;
                this.onUploadTooLarge.fire(new UploadTooLargeEventData(tooLargeEvent.getFileName(), tooLargeEvent.getMimeType(), tooLargeEvent.getSizeInBytes()));
                break;
            }
            case UI_PICTURE_CHOOSER_UPLOAD_STARTED: {
                UiPictureChooser.UploadStartedEvent uploadStartedEvent = (UiPictureChooser.UploadStartedEvent)event;
                this.onUploadStarted.fire(new UploadStartedEventData(uploadStartedEvent.getFileName(), uploadStartedEvent.getMimeType(), uploadStartedEvent.getSizeInBytes()));
                break;
            }
            case UI_PICTURE_CHOOSER_UPLOAD_CANCELED: {
                UiPictureChooser.UploadCanceledEvent canceledEvent = (UiPictureChooser.UploadCanceledEvent)event;
                this.onUploadCanceled.fire(new UploadCanceledEventData(canceledEvent.getFileName(), canceledEvent.getMimeType(), canceledEvent.getSizeInBytes()));
                break;
            }
            case UI_PICTURE_CHOOSER_UPLOAD_FAILED: {
                UiPictureChooser.UploadFailedEvent failedEvent = (UiPictureChooser.UploadFailedEvent)event;
                this.onUploadFailed.fire(new UploadFailedEventData(failedEvent.getFileName(), failedEvent.getMimeType(), failedEvent.getSizeInBytes()));
                break;
            }
            case UI_PICTURE_CHOOSER_UPLOAD_SUCCESSFUL: {
                UiPictureChooser.UploadSuccessfulEvent uploadedEvent = (UiPictureChooser.UploadSuccessfulEvent)event;
                this.uploadedFile = new UploadedFile(uploadedEvent.getUploadedFileUuid(), uploadedEvent.getFileName(), uploadedEvent.getSizeInBytes(), uploadedEvent.getMimeType(), () -> {
                    try {
                        return new FileInputStream(this.getSessionContext().getUploadedFileByUuid(uploadedEvent.getUploadedFileUuid()));
                    }
                    catch (FileNotFoundException e) {
                        throw new UploadedFileAccessException(e);
                    }
                }, () -> this.getSessionContext().getUploadedFileByUuid(uploadedEvent.getUploadedFileUuid()));
                this.onUploadSuccessful.fire(this.uploadedFile);
                this.showImageCropperWindow();
                break;
            }
        }
    }

    private void showImageCropperWindow() {
        this.imageCropper.setImageUrl(this.getSessionContext().createFileLink(this.uploadedFile.getAsFile()));
        this.getSessionContext().showWindow(this.imageCropperWindow, 200);
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
        this.queueCommandIfRendered(() -> new UiPictureChooser.SetMaxFileSizeCommand(this.getId(), maxFileSize));
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
        this.queueCommandIfRendered(() -> new UiPictureChooser.SetUploadUrlCommand(this.getId(), uploadUrl));
    }

    public String getFileTooLargeMessage() {
        return this.fileTooLargeMessage;
    }

    public void setFileTooLargeMessage(String fileTooLargeMessage) {
        this.fileTooLargeMessage = fileTooLargeMessage;
        this.queueCommandIfRendered(() -> new UiPictureChooser.SetFileTooLargeMessageCommand(this.getId(), fileTooLargeMessage));
    }

    public String getUploadErrorMessage() {
        return this.uploadErrorMessage;
    }

    public void setUploadErrorMessage(String uploadErrorMessage) {
        this.uploadErrorMessage = uploadErrorMessage;
        this.queueCommandIfRendered(() -> new UiPictureChooser.SetUploadErrorMessageCommand(this.getId(), uploadErrorMessage));
    }

    public Icon getBrowseButtonIcon() {
        return this.browseButtonIcon;
    }

    public void setBrowseButtonIcon(Icon browseButtonIcon) {
        this.browseButtonIcon = browseButtonIcon;
    }

    public Icon getDeleteButtonIcon() {
        return this.deleteButtonIcon;
    }

    public void setDeleteButtonIcon(Icon deleteButtonIcon) {
        this.deleteButtonIcon = deleteButtonIcon;
    }

    public int getTargetImageWidth() {
        return this.targetImageWidth;
    }

    public void setTargetImageWidth(int targetImageWidth) {
        this.targetImageWidth = targetImageWidth;
        this.imageCropper.setAspectRatio(Float.valueOf((float)targetImageWidth / (float)this.targetImageHeight));
    }

    public int getTargetImageHeight() {
        return this.targetImageHeight;
    }

    public void setTargetImageHeight(int targetImageHeight) {
        this.targetImageHeight = targetImageHeight;
        this.imageCropper.setAspectRatio(Float.valueOf((float)this.targetImageWidth / (float)targetImageHeight));
    }

    public void setTargetImageSize(int width, int height) {
        this.targetImageWidth = width;
        this.targetImageHeight = height;
        this.imageCropper.setAspectRatio(Float.valueOf((float)width / (float)height));
    }

    public int getImageDisplayWidth() {
        return this.imageDisplayWidth;
    }

    public void setImageDisplayWidth(int imageDisplayWidth) {
        this.imageDisplayWidth = imageDisplayWidth;
    }

    public int getImageDisplayHeight() {
        return this.imageDisplayHeight;
    }

    public void setImageDisplayHeight(int imageDisplayHeight) {
        this.imageDisplayHeight = imageDisplayHeight;
    }

    public void setImageDisplaySize(int imageDisplayWidth, int imageDisplayHeight) {
        this.imageDisplayWidth = imageDisplayWidth;
        this.imageDisplayHeight = imageDisplayHeight;
    }

    public static interface ImageCropperConverter {
        public Resource convert(UploadedFile var1, ImageCropperSelection var2, int var3, int var4) throws IOException;
    }
}

