/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiRootPanel;
import org.teamapps.event.Event;
import org.teamapps.icons.api.IconTheme;
import org.teamapps.server.UxServerContext;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.ux.caption.MultiResourceBundle;
import org.teamapps.ux.component.popup.Popup;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.template.TemplateReference;
import org.teamapps.ux.json.UxJacksonSerializationTemplate;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.session.ClientInfo;
import org.teamapps.ux.session.ClientSessionResourceProvider;
import org.teamapps.ux.session.CommandDispatcher;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.LockableSessionContext;
import org.teamapps.ux.session.SessionConfiguration;
import org.teamapps.ux.session.SessionStore;
import org.teamapps.ux.session.SimpleSessionStore;

public class SimpleSessionContext
implements LockableSessionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSessionContext.class);
    private static final int LOCK_TIMEOUT = 60000;
    private static final Function<Locale, ResourceBundle> DEFAULT_RESOURCE_BUNDLE_PROVIDER = locale -> ResourceBundle.getBundle("org.teamapps.ux.i18n.DefaultCaptions", locale, new UTF8Control());
    private final Event<Void> onDestroyed = new Event();
    private final ReentrantLock lock = new ReentrantLock();
    private boolean isValid = true;
    private long lastClientEventTimeStamp;
    private final QualifiedUiSessionId sessionId;
    private final ClientInfo clientInfo;
    private final CommandDispatcher commandDispatcher;
    private final UxServerContext serverContext;
    private final UxJacksonSerializationTemplate uxJacksonSerializationTemplate;
    private final SessionStore sessionStore;
    private IconTheme iconTheme;
    private ClientSessionResourceProvider sessionResourceProvider;
    private Function<Locale, ResourceBundle> customMessageBundleProvider = DEFAULT_RESOURCE_BUNDLE_PROVIDER;
    private ResourceBundle messagesBundle;
    private Map<String, Template> registeredTemplates = new ConcurrentHashMap<String, Template>();
    private SessionConfiguration sessionConfiguration = SessionConfiguration.createDefault();

    public SimpleSessionContext(QualifiedUiSessionId sessionId, ClientInfo clientInfo, CommandDispatcher commandDispatcher, UxServerContext serverContext, IconTheme iconTheme, ObjectMapper jacksonObjectMapper) {
        this.sessionId = sessionId;
        this.clientInfo = clientInfo;
        this.commandDispatcher = commandDispatcher;
        this.serverContext = serverContext;
        this.sessionStore = new SimpleSessionStore();
        this.iconTheme = iconTheme;
        this.sessionResourceProvider = new ClientSessionResourceProvider(sessionId);
        this.uxJacksonSerializationTemplate = new UxJacksonSerializationTemplate(jacksonObjectMapper, this);
        this.lastClientEventTimeStamp = System.currentTimeMillis();
        this.updateMessageBundle();
    }

    public void setCustomMessageBundleProvider(Function<Locale, ResourceBundle> provider) {
        this.customMessageBundleProvider = provider;
        this.updateMessageBundle();
    }

    private void updateMessageBundle() {
        if (this.customMessageBundleProvider != null) {
            ResourceBundle customResourceBundle = this.customMessageBundleProvider.apply(this.sessionConfiguration.getLanguageLocale());
            ResourceBundle defaultResourceBundle = DEFAULT_RESOURCE_BUNDLE_PROVIDER.apply(this.sessionConfiguration.getLanguageLocale());
            this.messagesBundle = new MultiResourceBundle(customResourceBundle, defaultResourceBundle);
        } else {
            this.messagesBundle = DEFAULT_RESOURCE_BUNDLE_PROVIDER.apply(this.sessionConfiguration.getLanguageLocale());
        }
    }

    @Override
    public Locale getLocale() {
        return this.sessionConfiguration.getLanguageLocale();
    }

    @Override
    public ResourceBundle getMessageBundle() {
        return this.messagesBundle;
    }

    @Override
    public String getLocalized(String key, Object ... parameters) {
        String value = this.messagesBundle.getString(key);
        if (parameters != null) {
            return MessageFormat.format(value, parameters);
        }
        return value;
    }

    @Override
    public long getLastClientEventTimestamp() {
        return this.lastClientEventTimeStamp;
    }

    @Override
    public void setLastClientEventTimestamp(long timestamp) {
        this.lastClientEventTimeStamp = timestamp;
    }

    @Override
    public boolean isOpen() {
        return this.isValid;
    }

    @Override
    public void destroy() {
        this.isValid = false;
        this.commandDispatcher.close();
        this.runWithContext(() -> this.onDestroyed.fire(null));
    }

    @Override
    public Event<Void> onDestroyed() {
        return this.onDestroyed;
    }

    public <RESULT> void queueCommand(UiCommand<RESULT> command, Consumer<RESULT> resultCallback) {
        if (CurrentSessionContext.get() != this) {
            String errorMessage = "Trying to queue a command for foreign SessionContext (CurrentSessionContext.get() != this). Please use SessionContext.runWithContext(Runnable). NOTE: The command will not get queued!";
            LOGGER.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        Consumer<Object> wrappedCallback = resultCallback != null ? result -> this.runWithContext(() -> resultCallback.accept(result)) : null;
        this.commandDispatcher.queueCommand(command, wrappedCallback);
    }

    public <RESULT> void queueCommand(UiCommand<RESULT> command) {
        this.queueCommand(command, (Consumer<RESULT>)null);
    }

    @Override
    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    @Override
    public void flushCommands() {
        this.uxJacksonSerializationTemplate.doWithUxJacksonSerializers(this.commandDispatcher::flushCommands);
    }

    @Override
    public IconTheme getIconTheme() {
        return this.iconTheme;
    }

    @Override
    public void setIconTheme(IconTheme theme) {
        this.iconTheme = theme;
    }

    @Override
    public SessionStore getSessionStore() {
        return this.sessionStore;
    }

    @Override
    public String createFileLink(File file) {
        return this.sessionResourceProvider.createFileLink(file);
    }

    @Override
    public String createResourceLink(Resource resource, String uniqueIdentifier) {
        return this.sessionResourceProvider.createResourceLink(resource, uniqueIdentifier);
    }

    @Override
    public Resource getBinaryResource(int resourceId) {
        return this.sessionResourceProvider.getBinaryResource(resourceId);
    }

    @Override
    public File getUploadedFileByUuid(String uuid) {
        return this.serverContext.getUploadedFileByUuid(uuid);
    }

    @Override
    public TemplateReference registerTemplate(String id, Template template) {
        this.registeredTemplates.put(id, template);
        this.queueCommand((UiCommand<RESULT>)((UiCommand)new UiRootPanel.RegisterTemplateCommand(id, template.createUiTemplate())));
        return new TemplateReference(template);
    }

    @Override
    public void registerTemplates(Map<String, Template> templates) {
        this.registeredTemplates.putAll(templates);
        this.queueCommand((UiCommand<RESULT>)((UiCommand)new UiRootPanel.RegisterTemplatesCommand(templates.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Template)entry.getValue()).createUiTemplate())))));
    }

    @Override
    public Template getTemplate(String id) {
        return this.registeredTemplates.get(id);
    }

    @Override
    public void lock(long timeoutMillis) {
        try {
            boolean locked = this.lock.tryLock(timeoutMillis, TimeUnit.MILLISECONDS);
            if (!locked) {
                String errorMessage = "Could not acquire lock for SessionContext " + this.sessionId + " after " + timeoutMillis + "ms.";
                LOGGER.error(errorMessage);
                throw new IllegalStateException(errorMessage);
            }
        }
        catch (InterruptedException e) {
            String errorMessage = "Could not acquire lock for SessionContext " + this.sessionId + ". Thread was interrupted while waiting for the lock!";
            LOGGER.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWithContext(Runnable runnable) {
        if (CurrentSessionContext.getOrNull() == this) {
            runnable.run();
        } else {
            if (CurrentSessionContext.getOrNull() != null) {
                CurrentSessionContext.getOrNull().unlock();
            }
            try {
                long startTime = System.currentTimeMillis();
                this.lock(60000L);
                try {
                    CurrentSessionContext.pushContext(this);
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception while executing runnable! Context: " + this.sessionId.toString(), (Throwable)e);
                        throw e;
                    }
                    finally {
                        CurrentSessionContext.popContext();
                    }
                }
                finally {
                    this.unlock();
                    long endTime = System.currentTimeMillis();
                    if (endTime - startTime > 60000L) {
                        String message = "The execution within the session context {} took dangerously long (longer than the session's lock timeout). This might have caused other threads to fail acquiring the session's lock. Stacktrace follows:";
                        LOGGER.warn(message, (Object)this.sessionId, (Object)new RuntimeException(message));
                    }
                }
            }
            finally {
                if (CurrentSessionContext.getOrNull() != null) {
                    CurrentSessionContext.getOrNull().lock(Long.MAX_VALUE);
                }
            }
            this.flushCommands();
        }
    }

    @Override
    public SessionConfiguration getConfiguration() {
        return this.sessionConfiguration;
    }

    @Override
    public void setConfiguration(SessionConfiguration config) {
        this.sessionConfiguration = config;
        this.updateMessageBundle();
        this.queueCommand((UiCommand<RESULT>)((UiCommand)new UiRootPanel.SetConfigCommand(config.createUiConfiguration())));
    }

    @Override
    public void showPopupAtCurrentMousePosition(Popup popup) {
        this.queueCommand((UiCommand<RESULT>)((UiCommand)new UiRootPanel.ShowPopupAtCurrentMousePositionCommand(popup.createUiComponentReference())));
    }

    @Override
    public void showPopup(Popup popup) {
        this.queueCommand((UiCommand<RESULT>)((UiCommand)new UiRootPanel.ShowPopupCommand(popup.createUiComponentReference())));
    }

    public static class UTF8Control
    extends ResourceBundle.Control {
        private String resourceFileSuffix;

        public UTF8Control() {
            this("properties");
        }

        public UTF8Control(String resourceFileSuffix) {
            this.resourceFileSuffix = resourceFileSuffix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, this.resourceFileSuffix);
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, StandardCharsets.UTF_8));
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

