/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.teamapps.ux.session.ExecutionDecorator;
import org.teamapps.ux.session.ExecutionDecoratorStack;

public class ExecutionDecoratorStackTest {
    @Test
    public void createWrappedRunnable() {
        ExecutionDecoratorStack stack = new ExecutionDecoratorStack();
        ArrayList<String> invocationTraces = new ArrayList<String>();
        ExecutionDecorator decorator1 = this.createDecorator(invocationTraces, "before 1", "after 1");
        ExecutionDecorator decorator2 = this.createDecorator(invocationTraces, "before 2", "after 2");
        ExecutionDecorator decorator3 = this.createDecorator(invocationTraces, "before 3", "after 3");
        stack.addOuterDecorator(decorator1);
        stack.addOuterDecorator(decorator2);
        stack.addOuterDecorator(decorator3);
        stack.createWrappedRunnable(() -> invocationTraces.add("actual execution")).run();
        Assertions.assertThat(invocationTraces).containsExactly((Object[])new String[]{"before 3", "before 2", "before 1", "actual execution", "after 1", "after 2", "after 3"});
    }

    @Test
    public void createWrappedRunnableAppendingInnerDecorator() {
        ExecutionDecoratorStack stack = new ExecutionDecoratorStack();
        ArrayList<String> invocationTraces = new ArrayList<String>();
        ExecutionDecorator decorator1 = this.createDecorator(invocationTraces, "before 1", "after 1");
        ExecutionDecorator decorator2 = this.createDecorator(invocationTraces, "before 2", "after 2");
        ExecutionDecorator decorator3 = this.createDecorator(invocationTraces, "before 3", "after 3");
        stack.addOuterDecorator(decorator1);
        stack.addOuterDecorator(decorator2);
        stack.addInnerDecorator(decorator3);
        stack.createWrappedRunnable(() -> invocationTraces.add("actual execution")).run();
        Assertions.assertThat(invocationTraces).containsExactly((Object[])new String[]{"before 2", "before 1", "before 3", "actual execution", "after 3", "after 1", "after 2"});
    }

    private ExecutionDecorator createDecorator(List<String> invocationTraces, String s, String s2) {
        return runnable -> {
            invocationTraces.add(s);
            runnable.run();
            invocationTraces.add(s2);
        };
    }
}

