/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.form;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.BeanPropertyInjector;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyInjector;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.component.field.validator.MultiFieldValidator;

public class LogicalForm<RECORD> {
    private final Map<String, AbstractField<?>> fieldsByPropertyName = new HashMap();
    private PropertyProvider<RECORD> propertyProvider = new BeanPropertyExtractor();
    private PropertyInjector<RECORD> propertyInjector = new BeanPropertyInjector();
    private final List<MultiFieldValidator> multiFieldValidators = new ArrayList<MultiFieldValidator>();

    public LogicalForm() {
    }

    public LogicalForm(PropertyProvider<RECORD> propertyProvider, PropertyInjector<RECORD> propertyInjector) {
        this.propertyProvider = propertyProvider;
        this.propertyInjector = propertyInjector;
    }

    public LogicalForm(PropertyExtractor<RECORD> propertyExtractor, PropertyInjector<RECORD> propertyInjector) {
        this((PropertyProvider<RECORD>)propertyExtractor, propertyInjector);
    }

    public LogicalForm(Map<String, AbstractField<?>> fieldsByPropertyName) {
        this.fieldsByPropertyName.putAll(fieldsByPropertyName);
    }

    public LogicalForm<RECORD> addField(String propertyName, AbstractField<?> field) {
        this.fieldsByPropertyName.put(propertyName, field);
        return this;
    }

    public LogicalForm<RECORD> removeField(AbstractField<?> field) {
        this.fieldsByPropertyName.remove(field);
        return this;
    }

    public void applyRecordValuesToFields(RECORD record) {
        Map<String, Object> values = this.propertyProvider.getValues(record, this.fieldsByPropertyName.keySet());
        values.forEach((propertyNames, value) -> {
            AbstractField<?> field = this.fieldsByPropertyName.get(propertyNames);
            if (field != null) {
                field.setValue(value);
            }
        });
    }

    public void applyFieldValuesToRecord(RECORD record) {
        Map fieldValues = this.fieldsByPropertyName.entrySet().stream().collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), ((AbstractField)entry.getValue()).getValue()), Map::putAll);
        this.propertyInjector.setValues(record, fieldValues);
    }

    public Map<String, AbstractField<?>> getFields() {
        return this.fieldsByPropertyName;
    }

    public PropertyProvider<RECORD> getPropertyProvider() {
        return this.propertyProvider;
    }

    public void setPropertyProvider(PropertyProvider<RECORD> propertyProvider) {
        this.propertyProvider = propertyProvider;
    }

    public void setPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        this.setPropertyProvider(propertyExtractor);
    }

    public PropertyInjector<RECORD> getPropertyInjector() {
        return this.propertyInjector;
    }

    public void setPropertyInjector(PropertyInjector<RECORD> propertyInjector) {
        this.propertyInjector = propertyInjector;
    }

    public void addMultiFieldValidator(MultiFieldValidator multiFieldValidator) {
        this.multiFieldValidators.add(multiFieldValidator);
    }

    public FieldMessage.Severity validate() {
        return Stream.concat(this.fieldsByPropertyName.values().stream().flatMap(f -> f.validate().stream()).map(FieldMessage::getSeverity), this.multiFieldValidators.stream().flatMap(v -> v.validate().stream()).map(FieldMessage::getSeverity)).max(Comparator.comparing(Enum::ordinal)).orElse(null);
    }
}

