/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.infiniteitemview;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiIdentifiableClientRecord;
import org.teamapps.dto.UiInfiniteItemView2;
import org.teamapps.event.Event;
import org.teamapps.ux.cache.record.DuplicateEntriesException;
import org.teamapps.ux.cache.record.ItemRange;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.VerticalElementAlignment;
import org.teamapps.ux.component.infiniteitemview.AbstractInfiniteListComponent;
import org.teamapps.ux.component.infiniteitemview.InfiniteItemViewModel;
import org.teamapps.ux.component.infiniteitemview.ItemClickedEventData;
import org.teamapps.ux.component.infiniteitemview.ListInfiniteItemViewModel;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class InfiniteItemView2<RECORD>
extends AbstractInfiniteListComponent<RECORD, InfiniteItemViewModel<RECORD>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public final Event<ItemClickedEventData<RECORD>> onItemClicked = new Event();
    private Template itemTemplate;
    private float itemWidth;
    private float itemHeight;
    private HorizontalElementAlignment itemContentHorizontalAlignment = HorizontalElementAlignment.STRETCH;
    private VerticalElementAlignment itemContentVerticalAlignment = VerticalElementAlignment.STRETCH;
    private int itemPositionAnimationTime = 200;
    private PropertyProvider<RECORD> itemPropertyProvider = new BeanPropertyExtractor();
    private int clientRecordIdCounter = 0;
    private Function<RECORD, Component> contextMenuProvider = null;
    private int lastSeenContextMenuRequestId;

    public InfiniteItemView2(Template itemTemplate, float itemWidth, int itemHeight) {
        super(new ListInfiniteItemViewModel());
        this.itemTemplate = itemTemplate;
        this.itemWidth = itemWidth;
        this.itemHeight = itemHeight;
    }

    public InfiniteItemView2(float itemWidth, int itemHeight) {
        this(BaseTemplate.ITEM_VIEW_ITEM, itemWidth, itemHeight);
    }

    public InfiniteItemView2() {
        this(BaseTemplate.ITEM_VIEW_ITEM, 300.0f, 300);
    }

    @Override
    public UiComponent createUiComponent() {
        UiInfiniteItemView2 ui = new UiInfiniteItemView2(this.itemTemplate.createUiTemplate());
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setItemWidth(this.itemWidth);
        ui.setItemHeight(this.itemHeight);
        ui.setItemContentHorizontalAlignment(this.itemContentHorizontalAlignment.toUiHorizontalElementAlignment());
        ui.setItemContentVerticalAlignment(this.itemContentVerticalAlignment.toUiVerticalElementAlignment());
        ui.setItemPositionAnimationTime((float)this.itemPositionAnimationTime);
        ui.setContextMenuEnabled(this.contextMenuProvider != null);
        return ui;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_INFINITE_ITEM_VIEW2_DISPLAYED_RANGE_CHANGED: {
                UiInfiniteItemView2.DisplayedRangeChangedEvent d = (UiInfiniteItemView2.DisplayedRangeChangedEvent)event;
                try {
                    this.handleScrollOrResize(ItemRange.startLength(d.getStartIndex(), d.getLength()));
                }
                catch (DuplicateEntriesException e) {
                    LOGGER.warn("DuplicateEntriesException while retrieving data from model. This means the underlying data of the model has changed without the model notifying this component, so will refresh the whole data of this component.");
                    this.refresh();
                }
                break;
            }
            case UI_INFINITE_ITEM_VIEW2_ITEM_CLICKED: {
                UiInfiniteItemView2.ItemClickedEvent e = (UiInfiniteItemView2.ItemClickedEvent)event;
                Object record = this.renderedRecords.getRecord(e.getRecordId());
                if (record == null) break;
                this.onItemClicked.fire(new ItemClickedEventData(record, e.getIsDoubleClick()));
                break;
            }
            case UI_INFINITE_ITEM_VIEW2_CONTEXT_MENU_REQUESTED: {
                UiInfiniteItemView2.ContextMenuRequestedEvent e = (UiInfiniteItemView2.ContextMenuRequestedEvent)event;
                this.lastSeenContextMenuRequestId = e.getRequestId();
                if (this.contextMenuProvider == null) {
                    this.closeContextMenu();
                    break;
                }
                Object record = this.renderedRecords.getRecord(e.getRecordId());
                if (record == null) break;
                Component contextMenuContent = this.contextMenuProvider.apply(record);
                if (contextMenuContent != null) {
                    this.queueCommandIfRendered(() -> new UiInfiniteItemView2.SetContextMenuContentCommand(this.getId(), e.getRequestId(), contextMenuContent.createUiReference()));
                    break;
                }
                this.queueCommandIfRendered(() -> new UiInfiniteItemView2.CloseContextMenuCommand(this.getId(), e.getRequestId()));
                break;
            }
        }
    }

    @Override
    protected List<RECORD> retrieveRecords(int startIndex, int length) {
        if (startIndex > this.getModelCount() || length <= 0) {
            return Collections.emptyList();
        }
        int actualStartIndex = Math.max(startIndex, 0);
        int actualLength = Math.min(this.getModelCount() - startIndex, length);
        return ((InfiniteItemViewModel)this.getModel()).getRecords(actualStartIndex, actualLength);
    }

    @Override
    protected void sendUpdateDataCommandToClient(int start, List<Integer> uiRecordIds, List<UiIdentifiableClientRecord> newUiRecords, int totalNumberOfRecords) {
        this.queueCommandIfRendered(() -> {
            LOGGER.debug("SENDING: renderedRange.start: {}; uiRecordIds.size: {}; renderedRecords.size: {}; totalCount: {}", new Object[]{start, uiRecordIds.size(), this.renderedRecords.size(), totalNumberOfRecords});
            return new UiInfiniteItemView2.SetDataCommand(this.getId(), start, uiRecordIds, newUiRecords, totalNumberOfRecords);
        });
    }

    @Override
    protected UiIdentifiableClientRecord createUiIdentifiableClientRecord(RECORD record) {
        UiIdentifiableClientRecord clientRecord = new UiIdentifiableClientRecord();
        clientRecord.setId(++this.clientRecordIdCounter);
        clientRecord.setValues(this.itemPropertyProvider.getValues(record, this.itemTemplate.getPropertyNames()));
        return clientRecord;
    }

    public Function<RECORD, Component> getContextMenuProvider() {
        return this.contextMenuProvider;
    }

    public void setContextMenuProvider(Function<RECORD, Component> contextMenuProvider) {
        this.contextMenuProvider = contextMenuProvider;
    }

    public void closeContextMenu() {
        this.queueCommandIfRendered(() -> new UiInfiniteItemView2.CloseContextMenuCommand(this.getId(), this.lastSeenContextMenuRequestId));
    }

    public Template getItemTemplate() {
        return this.itemTemplate;
    }

    public InfiniteItemView2<RECORD> setItemTemplate(Template itemTemplate) {
        this.itemTemplate = itemTemplate;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView2.SetItemTemplateCommand(this.getId(), itemTemplate.createUiTemplate()));
        return this;
    }

    public float getItemWidth() {
        return this.itemWidth;
    }

    public InfiniteItemView2<RECORD> setItemWidth(float itemWidth) {
        this.itemWidth = itemWidth;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView2.SetItemWidthCommand(this.getId(), itemWidth));
        return this;
    }

    public float getItemHeight() {
        return this.itemHeight;
    }

    public InfiniteItemView2<RECORD> setItemHeight(float itemHeight) {
        this.itemHeight = itemHeight;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView2.SetItemHeightCommand(this.getId(), itemHeight));
        return this;
    }

    public HorizontalElementAlignment getItemContentHorizontalAlignment() {
        return this.itemContentHorizontalAlignment;
    }

    public InfiniteItemView2<RECORD> setItemContentHorizontalAlignment(HorizontalElementAlignment itemContentHorizontalAlignment) {
        this.itemContentHorizontalAlignment = itemContentHorizontalAlignment;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView2.SetItemContentHorizontalAlignmentCommand(this.getId(), itemContentHorizontalAlignment.toUiHorizontalElementAlignment()));
        return this;
    }

    public VerticalElementAlignment getItemContentVerticalAlignment() {
        return this.itemContentVerticalAlignment;
    }

    public InfiniteItemView2<RECORD> setItemContentVerticalAlignment(VerticalElementAlignment itemContentVerticalAlignment) {
        this.itemContentVerticalAlignment = itemContentVerticalAlignment;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView2.SetItemContentVerticalAlignmentCommand(this.getId(), itemContentVerticalAlignment.toUiVerticalElementAlignment()));
        return this;
    }

    public int getItemPositionAnimationTime() {
        return this.itemPositionAnimationTime;
    }

    public void setItemPositionAnimationTime(int itemPositionAnimationTime) {
        this.itemPositionAnimationTime = itemPositionAnimationTime;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView2.SetItemPositionAnimationTimeCommand(this.getId(), itemPositionAnimationTime));
    }

    public PropertyProvider<RECORD> getItemPropertyProvider() {
        return this.itemPropertyProvider;
    }

    public void setItemPropertyProvider(PropertyProvider<RECORD> propertyProvider) {
        this.itemPropertyProvider = propertyProvider;
    }

    public void setItemPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        this.setItemPropertyProvider(propertyExtractor);
    }
}

