/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.i18n;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.stream.Collectors;
import org.teamapps.ux.i18n.TranslationProvider;

public class RankedTranslationProvider
implements TranslationProvider {
    private final List<TranslationProvider> translationProviders;

    public RankedTranslationProvider(TranslationProvider ... translationProviders) {
        this.translationProviders = Arrays.asList(translationProviders);
    }

    @Override
    public String getTranslation(String key, Locale locale) {
        for (TranslationProvider translationProvider : this.translationProviders) {
            try {
                return translationProvider.getTranslation(key, locale);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        throw new MissingResourceException("Can't find resource " + key, this.getClass().getName(), key);
    }

    public Set<String> getKeys(Locale locale) {
        return this.translationProviders.stream().flatMap(tp -> tp.getKeys(locale).stream()).collect(Collectors.toSet());
    }
}

