/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.glassfish.jersey.uri.UriTemplate;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.ux.session.navigation.AnnotationBasedRouteHandlerFactory;
import org.teamapps.ux.session.navigation.NavigationHistoryOperation;
import org.teamapps.ux.session.navigation.Registration;
import org.teamapps.ux.session.navigation.RelativeRouteInfo;
import org.teamapps.ux.session.navigation.Route;
import org.teamapps.ux.session.navigation.RouteHandler;
import org.teamapps.ux.session.navigation.RoutingUtil;
import org.teamapps.ux.session.navigation.WithNavigationHistoryChangeOperation;

public class Router {
    static final String PATH_REMAINDER_VARNAME = "_remainder";
    static final String PATH_REMAINDER_SUFFIX = "{_remainder:(/.*)?}";
    private final String pathPrefix;
    private final UriTemplate pathPrefixTemplate;
    private final UriTemplate pathPrefixExactTemplate;
    private final List<UriTemplateAndHandler> handlers = new CopyOnWriteArrayList<UriTemplateAndHandler>();
    private String path;
    private NavigationHistoryOperation pathChangeOperation;
    private final Map<String, WithNavigationHistoryChangeOperation<String>> queryParams = new HashMap<String, WithNavigationHistoryChangeOperation<String>>();
    private Supplier<String> pathSupplier;
    private NavigationHistoryOperation pathSupplierChangeOperation;
    private final Map<String, WithNavigationHistoryChangeOperation<Supplier<String>>> queryParameterSuppliers = new HashMap<String, WithNavigationHistoryChangeOperation<Supplier<String>>>();
    private final List<WithNavigationHistoryChangeOperation<Supplier<Map<String, String>>>> queryParametersSuppliers = new ArrayList<WithNavigationHistoryChangeOperation<Supplier<Map<String, String>>>>();
    private Supplier<Route> routeSupplier;
    private NavigationHistoryOperation routeSupplierChangeOperation;
    private final List<Runnable> routeHandlingChangeListeners = new ArrayList<Runnable>();

    public Router(String pathPrefix) {
        this.pathPrefix = RoutingUtil.normalizePath(pathPrefix);
        this.pathPrefixTemplate = this.createUriTemplate(this.pathPrefix, false);
        this.pathPrefixExactTemplate = this.createUriTemplate(this.pathPrefix, true);
    }

    private UriTemplate createUriTemplate(String path, boolean exact) {
        path = RoutingUtil.normalizePath(path);
        Object templateString = exact ? path : (RoutingUtil.isEmptyPath(path) ? PATH_REMAINDER_SUFFIX : path + PATH_REMAINDER_SUFFIX);
        return new UriTemplate((String)templateString);
    }

    public RelativeRouteInfo calculateRelativeRouteInfo() {
        NavigationHistoryOperation changeOperation;
        String paramValue;
        String paramName;
        Route route = Route.create();
        NavigationHistoryOperation pathChangeOperation = NavigationHistoryOperation.REPLACE;
        HashSet<String> queryParameterNamesTriggeringPush = new HashSet<String>();
        if (this.routeSupplier != null) {
            route = this.routeSupplier.get();
            pathChangeOperation = this.routeSupplierChangeOperation;
            if (this.routeSupplierChangeOperation == NavigationHistoryOperation.PUSH) {
                queryParameterNamesTriggeringPush.addAll(route.getQueryParams().keySet());
            }
        }
        for (WithNavigationHistoryChangeOperation<Supplier<Map<String, String>>> withNavigationHistoryChangeOperation : this.queryParametersSuppliers) {
            Map<String, String> queryParameters = withNavigationHistoryChangeOperation.getValue().get();
            route = route.withQueryParams(queryParameters);
            if (withNavigationHistoryChangeOperation.getNavigationHistoryOperation() == NavigationHistoryOperation.PUSH) {
                queryParameterNamesTriggeringPush.addAll(queryParameters.keySet());
                continue;
            }
            queryParameterNamesTriggeringPush.removeAll(queryParameters.keySet());
        }
        for (Map.Entry entry : this.queryParameterSuppliers.entrySet()) {
            paramName = (String)entry.getKey();
            paramValue = (String)((Supplier)((WithNavigationHistoryChangeOperation)entry.getValue()).getValue()).get();
            changeOperation = ((WithNavigationHistoryChangeOperation)entry.getValue()).getNavigationHistoryOperation();
            route = route.withQueryParam(paramName, paramValue);
            if (changeOperation == NavigationHistoryOperation.PUSH) {
                queryParameterNamesTriggeringPush.add(paramName);
                continue;
            }
            queryParameterNamesTriggeringPush.remove(paramName);
        }
        if (this.pathSupplier != null) {
            String path = this.pathSupplier.get();
            route = route.withPath(path);
            pathChangeOperation = this.pathSupplierChangeOperation;
        }
        for (Map.Entry entry : this.queryParams.entrySet()) {
            paramName = (String)entry.getKey();
            paramValue = (String)((WithNavigationHistoryChangeOperation)entry.getValue()).getValue();
            changeOperation = ((WithNavigationHistoryChangeOperation)entry.getValue()).getNavigationHistoryOperation();
            route = route.withQueryParam(paramName, paramValue);
            if (changeOperation == NavigationHistoryOperation.PUSH) {
                queryParameterNamesTriggeringPush.add(paramName);
                continue;
            }
            queryParameterNamesTriggeringPush.remove(paramName);
        }
        if (this.path != null) {
            route = route.withPath(this.path);
            pathChangeOperation = this.pathChangeOperation;
        }
        return new RelativeRouteInfo(route, pathChangeOperation == NavigationHistoryOperation.PUSH, queryParameterNamesTriggeringPush);
    }

    public Registration registerRouteHandler(String pathTemplate, RouteHandler handler) {
        return this.registerRouteHandler(pathTemplate, false, handler);
    }

    public Registration registerRouteHandler(String pathTemplate, boolean exact, RouteHandler handler) {
        UriTemplate uriTemplate = this.createUriTemplate(pathTemplate, exact);
        UriTemplateAndHandler templateAndRouter = new UriTemplateAndHandler(uriTemplate, handler);
        this.handlers.add(templateAndRouter);
        this.handlers.sort(Comparator.comparing(h -> h.getUriTemplate().getTemplate().length()));
        this.fireRouteHandlingChange();
        return () -> this.handlers.remove(templateAndRouter);
    }

    public Registration registerRouteHandlers(Object annotatedClassInstance) {
        List registrations = new AnnotationBasedRouteHandlerFactory(SessionContext.current().getRoutingParamConverterProvider()).createRouteHandlers(annotatedClassInstance).stream().map(handler -> this.registerRouteHandler(handler.getPathTemplate(), handler.isExact(), (RouteHandler)handler)).collect(Collectors.toList());
        this.fireRouteHandlingChange();
        return () -> registrations.forEach(Registration::dispose);
    }

    public Router getSubRouter(String relativePath) {
        return SessionContext.current().getRouter(RoutingUtil.concatenatePaths(this.pathPrefix, relativePath));
    }

    public void route(Route route) {
        for (UriTemplateAndHandler uriTemplateAndHandler : this.handlers) {
            HashMap<String, String> pathParams = new HashMap<String, String>();
            boolean matches = uriTemplateAndHandler.getUriTemplate().match((CharSequence)route.getPath(), pathParams);
            if (!matches) continue;
            uriTemplateAndHandler.getHandler().handle(route.getPath(), pathParams, route.getQueryParams());
        }
    }

    public void setPath(String path) {
        this.setPath(path, NavigationHistoryOperation.PUSH);
    }

    public void setPath(String path, NavigationHistoryOperation changeOperation) {
        this.path = path;
        this.pathChangeOperation = changeOperation;
    }

    public void setQueryParameter(String parameterName, String value) {
        this.setQueryParameter(parameterName, value, NavigationHistoryOperation.PUSH);
    }

    public void setQueryParameter(String parameterName, String value, NavigationHistoryOperation changeOperation) {
        this.queryParams.put(parameterName, new WithNavigationHistoryChangeOperation<String>(value, changeOperation));
    }

    public Registration setPathSupplier(Supplier<String> pathSupplier) {
        return this.setPathSupplier(pathSupplier, NavigationHistoryOperation.PUSH);
    }

    public Registration setPathSupplier(Supplier<String> pathSupplier, NavigationHistoryOperation changeOperation) {
        this.pathSupplier = pathSupplier;
        this.pathSupplierChangeOperation = changeOperation;
        return () -> {
            if (this.pathSupplier == pathSupplier) {
                this.pathSupplier = null;
            }
        };
    }

    public Registration setQueryParameterSupplier(String parameterName, Supplier<String> supplier) {
        return this.setQueryParameterSupplier(parameterName, supplier, NavigationHistoryOperation.PUSH);
    }

    public Registration setQueryParameterSupplier(String parameterName, Supplier<String> supplier, NavigationHistoryOperation changeOperation) {
        this.queryParameterSuppliers.put(parameterName, new WithNavigationHistoryChangeOperation<Supplier<String>>(supplier, changeOperation));
        return () -> {
            if (this.queryParameterSuppliers.get(parameterName) != null && this.queryParameterSuppliers.get(parameterName).getValue() == supplier) {
                this.queryParameterSuppliers.remove(parameterName);
            }
        };
    }

    public Registration addQueryParametersSupplier(Supplier<Map<String, String>> supplier) {
        return this.addQueryParametersSupplier(supplier, NavigationHistoryOperation.PUSH);
    }

    public Registration addQueryParametersSupplier(Supplier<Map<String, String>> supplier, NavigationHistoryOperation changeOperation) {
        this.queryParametersSuppliers.add(new WithNavigationHistoryChangeOperation<Supplier<Map<String, String>>>(supplier, changeOperation));
        return () -> this.queryParametersSuppliers.removeIf(arg_0 -> Router.lambda$addQueryParametersSupplier$6((Supplier)supplier, changeOperation, arg_0));
    }

    public Registration setRouteSupplier(Supplier<Route> supplier) {
        return this.setRouteSupplier(supplier, NavigationHistoryOperation.PUSH);
    }

    public Registration setRouteSupplier(Supplier<Route> supplier, NavigationHistoryOperation changeOperation) {
        this.routeSupplier = supplier;
        this.routeSupplierChangeOperation = changeOperation;
        return () -> {
            if (this.routeSupplier == supplier) {
                this.routeSupplier = null;
            }
        };
    }

    public boolean matchesPath(String path) {
        return this.pathPrefixTemplate.match((CharSequence)path, new HashMap());
    }

    public boolean matchesPathPrefix(String pathPrefix) {
        return this.pathPrefixExactTemplate.match((CharSequence)pathPrefix, new HashMap());
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public Registration addChangeListener(Runnable listener) {
        this.routeHandlingChangeListeners.add(listener);
        return () -> this.routeHandlingChangeListeners.remove(listener);
    }

    private void fireRouteHandlingChange() {
        this.routeHandlingChangeListeners.forEach(Runnable::run);
    }

    private static /* synthetic */ boolean lambda$addQueryParametersSupplier$6(Supplier supplier, NavigationHistoryOperation changeOperation, WithNavigationHistoryChangeOperation sao) {
        return sao.getValue() == supplier && sao.getNavigationHistoryOperation() == changeOperation;
    }

    private static class UriTemplateAndHandler {
        private final UriTemplate uriTemplate;
        private final RouteHandler handler;

        public UriTemplateAndHandler(UriTemplate uriTemplate, RouteHandler handler) {
            this.uriTemplate = uriTemplate;
            this.handler = handler;
        }

        public UriTemplate getUriTemplate() {
            return this.uriTemplate;
        }

        public RouteHandler getHandler() {
            return this.handler;
        }
    }
}

