/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.data.extract;

import org.junit.Assert;
import org.junit.Test;
import org.teamapps.data.extract.BeanPropertyInjector;

public class BeanPropertyInjectorTest {
    @Test
    public void testSetValueUsingProperty() throws Exception {
        BeanPropertyInjector injector = new BeanPropertyInjector();
        A record = new A();
        injector.setValue((Object)record, "q", (Object)"newQValue");
        Assert.assertEquals((Object)"newQValue", (Object)record.q);
    }

    @Test
    public void testNotSetPublicFieldValue() throws Exception {
        BeanPropertyInjector injector = new BeanPropertyInjector();
        A record = new A();
        injector.setValue((Object)record, "publicField", (Object)9);
        Assert.assertEquals((long)1337L, (long)record.publicField);
    }

    @Test
    public void testSetPublicFieldValue() throws Exception {
        BeanPropertyInjector injector = new BeanPropertyInjector(true);
        A record = new A();
        injector.setValue((Object)record, "publicField", (Object)9);
        Assert.assertEquals((long)9L, (long)record.publicField);
    }

    @Test
    public void testValueInjectorsAreCachedSeparatelyDependingOnFallbackToFields() throws Exception {
        BeanPropertyInjector injector = new BeanPropertyInjector();
        A record = new A();
        injector.setValue((Object)record, "x", (Object)"foo");
        Assert.assertEquals((Object)"xValue", (Object)record.x);
        BeanPropertyInjector injector2 = new BeanPropertyInjector(true);
        injector2.setValue((Object)record, "x", (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)record.x);
    }

    @Test
    public void testDoesNotChangeFinalFields() throws Exception {
        BeanPropertyInjector injector = new BeanPropertyInjector(true);
        A record = new A();
        injector.setValue((Object)record, "finalField", (Object)"foo");
        Assert.assertEquals((Object)"finalFieldValue", (Object)record.finalField);
    }

    @Test
    public void testSetPrivateFieldValue() throws Exception {
        BeanPropertyInjector injector = new BeanPropertyInjector(true);
        A record = new A();
        injector.setValue((Object)record, "privateField", (Object)7);
        Assert.assertEquals((long)7L, (long)record.privateField);
    }

    @Test
    public void testAddCustomValueInjector() throws Exception {
        BeanPropertyInjector injector = new BeanPropertyInjector();
        injector.addProperty("blah", (record, value) -> {
            record.custom = (String)value;
        });
        A record2 = new A();
        injector.setValue((Object)record2, "blah", (Object)"blub");
        Assert.assertEquals((Object)"blub", (Object)record2.custom);
    }

    @Test
    public void testAddCustomValueInjectorOverwritesProperty() throws Exception {
        BeanPropertyInjector injector = new BeanPropertyInjector();
        injector.addProperty("q", (record, value) -> {
            record.custom = (String)value;
        });
        A record2 = new A();
        injector.setValue((Object)record2, "q", (Object)"blub");
        Assert.assertEquals((Object)"qValue", (Object)record2.q);
        Assert.assertEquals((Object)"blub", (Object)record2.custom);
    }

    public static class A {
        private String q = "qValue";
        public int publicField = 1337;
        private int privateField = 2337;
        private String custom;
        private String x = "xValue";
        private final String finalField = "finalFieldValue";

        public void setQ(String q) {
            this.q = q;
        }
    }
}

