/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.teamapps.json.TeamAppsObjectMapperFactory;

public class JacksonConfigJavaTimeTest {
    private final ObjectMapper teamAppsObjectMapper = TeamAppsObjectMapperFactory.create();

    @Test
    public void instant() throws Exception {
        Assertions.assertThat((String)this.teamAppsObjectMapper.writeValueAsString((Object)Instant.ofEpochMilli(1528910356690L))).isEqualTo("1528910356690");
        Assertions.assertThat((Instant)((Instant)this.teamAppsObjectMapper.readValue("1528910356690", Instant.class))).isEqualTo((Object)Instant.ofEpochMilli(1528910356690L));
    }

    @Test
    public void localDateTime() throws Exception {
        Assertions.assertThat((String)this.teamAppsObjectMapper.writeValueAsString((Object)LocalDate.of(2020, 1, 1))).isEqualTo("[2020,1,1]");
        Assertions.assertThat((LocalDate)((LocalDate)this.teamAppsObjectMapper.readValue("[2020,1,1]", LocalDate.class))).isEqualTo((Object)LocalDate.of(2020, 1, 1));
    }

    @Test
    public void localDate() throws Exception {
        Assertions.assertThat((String)this.teamAppsObjectMapper.writeValueAsString((Object)LocalDateTime.of(2020, 1, 1, 1, 1))).isEqualTo("[2020,1,1,1,1]");
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.teamAppsObjectMapper.readValue("[2020,1,1,1,1]", LocalDateTime.class))).isEqualTo((Object)LocalDateTime.of(2020, 1, 1, 1, 1));
    }
}

