/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.junit.Test;
import org.teamapps.dto.UiCommand;
import org.teamapps.json.TeamAppsObjectMapperFactory;

public class JsonDeserializationBenchmark {
    private final ObjectMapper teamAppsObjectMapper = TeamAppsObjectMapperFactory.create();

    @Test
    public void testLowLevelJsonParsingPerformance() throws Exception {
        String json = JsonDeserializationBenchmark.readResourceToString("sample.json");
        JsonNode[] jsonNodes = new JsonNode[1024];
        UiCommand[] uiCommands = new UiCommand[1024];
        for (int j = 0; j < 5; ++j) {
            int i;
            long startTime = System.currentTimeMillis();
            for (i = 0; i < 1000; ++i) {
                jsonNodes[i % 1024] = this.teamAppsObjectMapper.readTree(json);
            }
            System.out.println("Jackson TreeNode: " + (System.currentTimeMillis() - startTime) + "ms");
            startTime = System.currentTimeMillis();
            for (i = 0; i < 1000; ++i) {
                uiCommands[i % 1024] = (UiCommand)this.teamAppsObjectMapper.readValue(json, UiCommand.class);
            }
            System.out.println("Jackson data binding (directly to Java objects!): " + (System.currentTimeMillis() - startTime) + "ms");
        }
        System.out.println(jsonNodes[0]);
        System.out.println(uiCommands[0]);
    }

    public static String readResourceToString(String resourceName) {
        URL url = Resources.getResource((String)resourceName);
        try {
            return Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

