/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.testutil;

import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mockito.Mockito;
import org.teamapps.common.TeamAppsVersion;
import org.teamapps.icons.SessionIconProvider;
import org.teamapps.server.UxServerContext;
import org.teamapps.uisession.UiSession;
import org.teamapps.util.threading.CloseableExecutor;
import org.teamapps.ux.session.ClientInfo;
import org.teamapps.ux.session.CurrentSessionContextTestUtil;
import org.teamapps.ux.session.SessionConfiguration;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.ux.session.navigation.Location;

public class UxTestUtil {
    public static CompletableFuture<Void> doWithMockedSessionContext(Runnable runnable) {
        SessionContext sessionContext = UxTestUtil.createDummySessionContext();
        return sessionContext.runWithContext(runnable);
    }

    public static SessionContext createDummySessionContext() {
        ClientInfo clientInfo = new ClientInfo("ip", 1024, 768, 1000, 700, "en", false, "Europe/Berlin", 120, Collections.emptyList(), "userAgentString", (Location)Mockito.mock(Location.class), Collections.emptyMap(), TeamAppsVersion.TEAMAPPS_VERSION);
        return new SessionContext((UiSession)Mockito.mock(UiSession.class), CloseableExecutor.fromExecutorService((ExecutorService)Executors.newSingleThreadExecutor()), clientInfo, SessionConfiguration.createForClientInfo((ClientInfo)clientInfo), (HttpSession)Mockito.mock(HttpSession.class), (UxServerContext)Mockito.mock(UxServerContext.class), (SessionIconProvider)Mockito.mock(SessionIconProvider.class), "", (ParamConverterProvider)Mockito.mock(ParamConverterProvider.class));
    }

    public static void runWithSessionContext(SessionContext sessionContext, Runnable runnable) {
        CurrentSessionContextTestUtil.set(sessionContext);
        try {
            runnable.run();
        }
        finally {
            CurrentSessionContextTestUtil.unset();
        }
    }
}

