/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.calendar;

import java.time.DayOfWeek;
import java.time.LocalDate;
import org.junit.Assert;
import org.junit.Test;
import org.teamapps.ux.component.calendar.CalendarViewMode;

public class CalendarViewModeTest {
    @Test
    public void testGetDisplayStartInstantForYear() throws Exception {
        int februaryDay;
        int displayedYear = 2000;
        for (februaryDay = 1; februaryDay <= 14; ++februaryDay) {
            Assert.assertEquals((Object)LocalDate.of(1999, 12, 27), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.MONDAY));
            Assert.assertEquals((Object)LocalDate.of(1999, 12, 28), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.TUESDAY));
            Assert.assertEquals((Object)LocalDate.of(1999, 12, 29), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.WEDNESDAY));
            Assert.assertEquals((Object)LocalDate.of(1999, 12, 30), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.THURSDAY));
            Assert.assertEquals((Object)LocalDate.of(1999, 12, 31), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.FRIDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 1, 1), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SATURDAY));
            Assert.assertEquals((Object)LocalDate.of(1999, 12, 26), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SUNDAY));
        }
        displayedYear = 2001;
        for (februaryDay = 1; februaryDay <= 14; ++februaryDay) {
            Assert.assertEquals((Object)LocalDate.of(2001, 1, 1), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.MONDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 12, 26), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.TUESDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 12, 27), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.WEDNESDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 12, 28), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.THURSDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 12, 29), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.FRIDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 12, 30), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SATURDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 12, 31), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SUNDAY));
        }
        displayedYear = 2002;
        for (februaryDay = 1; februaryDay <= 14; ++februaryDay) {
            Assert.assertEquals((Object)LocalDate.of(2001, 12, 31), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.MONDAY));
            Assert.assertEquals((Object)LocalDate.of(2002, 1, 1), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.TUESDAY));
            Assert.assertEquals((Object)LocalDate.of(2001, 12, 26), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.WEDNESDAY));
            Assert.assertEquals((Object)LocalDate.of(2001, 12, 27), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.THURSDAY));
            Assert.assertEquals((Object)LocalDate.of(2001, 12, 28), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.FRIDAY));
            Assert.assertEquals((Object)LocalDate.of(2001, 12, 29), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SATURDAY));
            Assert.assertEquals((Object)LocalDate.of(2001, 12, 30), (Object)CalendarViewMode.YEAR.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SUNDAY));
        }
    }

    @Test
    public void getDisplayEndInstantForYear() throws Exception {
        int februaryDay;
        int displayedYear = 2000;
        for (februaryDay = 1; februaryDay <= 14; ++februaryDay) {
            Assert.assertEquals((Object)LocalDate.of(2001, 1, 8), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.MONDAY));
            Assert.assertEquals((Object)LocalDate.of(2001, 1, 9), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.TUESDAY));
            Assert.assertEquals((Object)LocalDate.of(2001, 1, 10), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.WEDNESDAY));
            Assert.assertEquals((Object)LocalDate.of(2001, 1, 11), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.THURSDAY));
            Assert.assertEquals((Object)LocalDate.of(2001, 1, 12), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.FRIDAY));
            Assert.assertEquals((Object)LocalDate.of(2001, 1, 6), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SATURDAY));
            Assert.assertEquals((Object)LocalDate.of(2001, 1, 7), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SUNDAY));
        }
        displayedYear = 2001;
        for (februaryDay = 1; februaryDay <= 14; ++februaryDay) {
            Assert.assertEquals((Object)LocalDate.of(2002, 1, 7), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.MONDAY));
            Assert.assertEquals((Object)LocalDate.of(2002, 1, 8), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.TUESDAY));
            Assert.assertEquals((Object)LocalDate.of(2002, 1, 9), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.WEDNESDAY));
            Assert.assertEquals((Object)LocalDate.of(2002, 1, 10), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.THURSDAY));
            Assert.assertEquals((Object)LocalDate.of(2002, 1, 11), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.FRIDAY));
            Assert.assertEquals((Object)LocalDate.of(2002, 1, 12), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SATURDAY));
            Assert.assertEquals((Object)LocalDate.of(2002, 1, 6), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SUNDAY));
        }
        displayedYear = 2002;
        for (februaryDay = 1; februaryDay <= 14; ++februaryDay) {
            Assert.assertEquals((Object)LocalDate.of(2003, 1, 6), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.MONDAY));
            Assert.assertEquals((Object)LocalDate.of(2003, 1, 7), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.TUESDAY));
            Assert.assertEquals((Object)LocalDate.of(2003, 1, 8), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.WEDNESDAY));
            Assert.assertEquals((Object)LocalDate.of(2003, 1, 9), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.THURSDAY));
            Assert.assertEquals((Object)LocalDate.of(2003, 1, 10), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.FRIDAY));
            Assert.assertEquals((Object)LocalDate.of(2003, 1, 11), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SATURDAY));
            Assert.assertEquals((Object)LocalDate.of(2003, 1, 12), (Object)CalendarViewMode.YEAR.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SUNDAY));
        }
    }

    @Test
    public void testGetDisplayStartInstantForMonth() throws Exception {
        int februaryDay;
        int displayedYear = 2000;
        for (februaryDay = 1; februaryDay <= 14; ++februaryDay) {
            Assert.assertEquals((Object)LocalDate.of(2000, 1, 31), (Object)CalendarViewMode.MONTH.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.MONDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 2, 1), (Object)CalendarViewMode.MONTH.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.TUESDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 1, 26), (Object)CalendarViewMode.MONTH.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.WEDNESDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 1, 27), (Object)CalendarViewMode.MONTH.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.THURSDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 1, 28), (Object)CalendarViewMode.MONTH.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.FRIDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 1, 29), (Object)CalendarViewMode.MONTH.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SATURDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 1, 30), (Object)CalendarViewMode.MONTH.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SUNDAY));
        }
        displayedYear = 2001;
        for (februaryDay = 1; februaryDay <= 14; ++februaryDay) {
            Assert.assertEquals((Object)LocalDate.of(2001, 1, 29), (Object)CalendarViewMode.MONTH.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.MONDAY));
            Assert.assertEquals((Object)LocalDate.of(2001, 1, 30), (Object)CalendarViewMode.MONTH.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.TUESDAY));
            Assert.assertEquals((Object)LocalDate.of(2001, 1, 31), (Object)CalendarViewMode.MONTH.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.WEDNESDAY));
            Assert.assertEquals((Object)LocalDate.of(2001, 2, 1), (Object)CalendarViewMode.MONTH.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.THURSDAY));
            Assert.assertEquals((Object)LocalDate.of(2001, 1, 26), (Object)CalendarViewMode.MONTH.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.FRIDAY));
            Assert.assertEquals((Object)LocalDate.of(2001, 1, 27), (Object)CalendarViewMode.MONTH.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SATURDAY));
            Assert.assertEquals((Object)LocalDate.of(2001, 1, 28), (Object)CalendarViewMode.MONTH.getDisplayStart(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SUNDAY));
        }
    }

    @Test
    public void getDisplayEndInstantForMonth() throws Exception {
        int displayedYear = 2000;
        for (int februaryDay = 1; februaryDay <= 14; ++februaryDay) {
            Assert.assertEquals((Object)LocalDate.of(2000, 3, 13), (Object)CalendarViewMode.MONTH.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.MONDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 3, 14), (Object)CalendarViewMode.MONTH.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.TUESDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 3, 8), (Object)CalendarViewMode.MONTH.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.WEDNESDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 3, 9), (Object)CalendarViewMode.MONTH.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.THURSDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 3, 10), (Object)CalendarViewMode.MONTH.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.FRIDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 3, 11), (Object)CalendarViewMode.MONTH.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SATURDAY));
            Assert.assertEquals((Object)LocalDate.of(2000, 3, 12), (Object)CalendarViewMode.MONTH.getDisplayEnd(LocalDate.of(displayedYear, 2, februaryDay), DayOfWeek.SUNDAY));
        }
    }
}

