/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.validator;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.teamapps.event.Event;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.validator.CustomValidator;
import org.teamapps.ux.component.field.validator.MultiFieldValidator;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.SessionContext;
import sun.misc.Unsafe;

public class MultiFieldValidatorTest {
    public static final String ERROR_MESSAGE = "some error";

    @Test
    public void testManualTriggeringDoesNotTriggerWhenFieldValueChanges() throws Exception {
        this.doWithFakeSessionContext(() -> {
            TextField field1 = new TextField();
            TextField field2 = new TextField();
            CustomValidator customValidatorMock = (CustomValidator)Mockito.mock(CustomValidator.class);
            Mockito.when((Object)customValidatorMock.validate()).thenReturn(List.of(new FieldMessage(FieldMessage.Severity.ERROR, ERROR_MESSAGE)));
            MultiFieldValidator validator = new MultiFieldValidator(customValidatorMock, new AbstractField[]{field1, field2});
            field1.onValueChanged.fire((Object)"asdf");
            this.verifyFieldMessages(field1.getFieldMessages(), new String[0]);
            this.verifyFieldMessages(field2.getFieldMessages(), new String[0]);
        });
    }

    @Test
    public void testManualTriggeringDoesNotPileUpMessages() throws Exception {
        this.doWithFakeSessionContext(() -> {
            TextField field1 = new TextField();
            TextField field2 = new TextField();
            CustomValidator customValidatorMock = (CustomValidator)Mockito.mock(CustomValidator.class);
            Mockito.when((Object)customValidatorMock.validate()).thenReturn(List.of(new FieldMessage(FieldMessage.Severity.ERROR, ERROR_MESSAGE)));
            MultiFieldValidator validator = new MultiFieldValidator(customValidatorMock, new AbstractField[]{field1, field2});
            List messages = validator.validate();
            this.verifyFieldMessages(messages, ERROR_MESSAGE);
            this.verifyFieldMessages(field1.getFieldMessages(), ERROR_MESSAGE);
            this.verifyFieldMessages(field2.getFieldMessages(), ERROR_MESSAGE);
            messages = validator.validate();
            this.verifyFieldMessages(messages, ERROR_MESSAGE);
            this.verifyFieldMessages(field1.getFieldMessages(), ERROR_MESSAGE);
            this.verifyFieldMessages(field2.getFieldMessages(), ERROR_MESSAGE);
        });
    }

    @Test
    public void testManualTriggeringClearsMessages() throws Exception {
        this.doWithFakeSessionContext(() -> {
            TextField field1 = new TextField();
            TextField field2 = new TextField();
            CustomValidator customValidatorMock = (CustomValidator)Mockito.mock(CustomValidator.class);
            Mockito.when((Object)customValidatorMock.validate()).thenReturn(List.of(new FieldMessage(FieldMessage.Severity.ERROR, ERROR_MESSAGE)));
            MultiFieldValidator validator = new MultiFieldValidator(customValidatorMock, new AbstractField[]{field1, field2});
            List messages = validator.validate();
            this.verifyFieldMessages(messages, ERROR_MESSAGE);
            this.verifyFieldMessages(field1.getFieldMessages(), ERROR_MESSAGE);
            this.verifyFieldMessages(field2.getFieldMessages(), ERROR_MESSAGE);
            Mockito.when((Object)customValidatorMock.validate()).thenReturn(List.of());
            messages = validator.validate();
            this.verifyFieldMessages(messages, new String[0]);
            this.verifyFieldMessages(field1.getFieldMessages(), new String[0]);
            this.verifyFieldMessages(field2.getFieldMessages(), new String[0]);
        });
    }

    @Test
    public void testTriggeringOnChange() throws Exception {
        this.doWithFakeSessionContext(() -> {
            TextField field1 = new TextField();
            TextField field2 = new TextField();
            CustomValidator customValidatorMock = (CustomValidator)Mockito.mock(CustomValidator.class);
            Mockito.when((Object)customValidatorMock.validate()).thenReturn(List.of(new FieldMessage(FieldMessage.Severity.ERROR, ERROR_MESSAGE)));
            MultiFieldValidator validator = new MultiFieldValidator(customValidatorMock, MultiFieldValidator.TriggeringPolicy.ON_FIELD_CHANGE, new AbstractField[]{field1, field2});
            field1.onValueChanged.fire((Object)"asdf");
            this.verifyFieldMessages(field1.getFieldMessages(), ERROR_MESSAGE);
            this.verifyFieldMessages(field2.getFieldMessages(), ERROR_MESSAGE);
        });
    }

    @Test
    public void testManualWithAutoClearRmovesMessages() throws Exception {
        this.doWithFakeSessionContext(() -> {
            TextField field1 = new TextField();
            TextField field2 = new TextField();
            CustomValidator customValidatorMock = (CustomValidator)Mockito.mock(CustomValidator.class);
            Mockito.when((Object)customValidatorMock.validate()).thenReturn(List.of(new FieldMessage(FieldMessage.Severity.ERROR, ERROR_MESSAGE)));
            MultiFieldValidator validator = new MultiFieldValidator(customValidatorMock, MultiFieldValidator.TriggeringPolicy.MANUALLY_WITH_AUTOCLEAR, new AbstractField[]{field1, field2});
            field1.onValueChanged.fire((Object)"asdf");
            List messages = validator.validate();
            this.verifyFieldMessages(messages, ERROR_MESSAGE);
            this.verifyFieldMessages(field1.getFieldMessages(), ERROR_MESSAGE);
            this.verifyFieldMessages(field2.getFieldMessages(), ERROR_MESSAGE);
            field2.onValueChanged.fire((Object)"qwerty");
            Assertions.assertThat((boolean)field1.getFieldMessages().isEmpty());
            Assertions.assertThat((boolean)field2.getFieldMessages().isEmpty());
        });
    }

    @Test
    public void testManualWithAutoClearReAddsMessageOnSecondValidation() throws Exception {
        this.doWithFakeSessionContext(() -> {
            TextField field1 = new TextField();
            TextField field2 = new TextField();
            CustomValidator customValidatorMock = (CustomValidator)Mockito.mock(CustomValidator.class);
            Mockito.when((Object)customValidatorMock.validate()).thenReturn(List.of(new FieldMessage(FieldMessage.Severity.ERROR, ERROR_MESSAGE)));
            MultiFieldValidator validator = new MultiFieldValidator(customValidatorMock, MultiFieldValidator.TriggeringPolicy.MANUALLY_WITH_AUTOCLEAR, new AbstractField[]{field1, field2});
            field1.onValueChanged.fire((Object)"asdf");
            List messages = validator.validate();
            this.verifyFieldMessages(messages, ERROR_MESSAGE);
            this.verifyFieldMessages(field1.getFieldMessages(), ERROR_MESSAGE);
            this.verifyFieldMessages(field2.getFieldMessages(), ERROR_MESSAGE);
            field2.onValueChanged.fire((Object)"qwerty");
            Assertions.assertThat((boolean)field1.getFieldMessages().isEmpty());
            Assertions.assertThat((boolean)field2.getFieldMessages().isEmpty());
            List validation2 = validator.validate();
            this.verifyFieldMessages(field1.getFieldMessages(), ERROR_MESSAGE);
            this.verifyFieldMessages(field2.getFieldMessages(), ERROR_MESSAGE);
        });
    }

    private void verifyFieldMessages(List<FieldMessage> fieldMessages, String ... errorMessages) {
        Assertions.assertThat(fieldMessages).extracting(FieldMessage::getMessage).containsExactly((Object[])errorMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWithFakeSessionContext(RunnableWithException r) throws Exception {
        Method set = CurrentSessionContext.class.getDeclaredMethod("set", SessionContext.class);
        set.setAccessible(true);
        SessionContext sessionContextMock = (SessionContext)Mockito.mock(SessionContext.class);
        MultiFieldValidatorTest.unsafelySetOnDestroyed(sessionContextMock, new Event());
        Mockito.when((Object)sessionContextMock.runWithContext((Runnable)Mockito.any(Runnable.class))).then(invocation -> {
            ((Runnable)invocation.getArguments()[0]).run();
            return CompletableFuture.completedFuture(null);
        });
        set.invoke(null, sessionContextMock);
        try {
            r.run();
        }
        catch (Throwable throwable) {
            set.invoke(null, new Object[]{null});
            throw throwable;
        }
        set.invoke(null, new Object[]{null});
    }

    private static void unsafelySetOnDestroyed(Object object, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        unsafeField.setAccessible(true);
        Unsafe unsafe = (Unsafe)unsafeField.get(null);
        Field f = object.getClass().getField("onDestroyed");
        unsafe.putObject(object, unsafe.objectFieldOffset(f), value);
    }

    public static interface RunnableWithException {
        public void run() throws Exception;
    }
}

