/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import java.net.MalformedURLException;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.teamapps.ux.session.navigation.Location;

public class LocationTest {
    @Test
    public void parse() throws MalformedURLException {
        Location location = Location.parse((String)"http://teamapps.org:8080/my/path?q=123#ref");
        Assertions.assertThat((String)location.getHref()).isEqualTo("http://teamapps.org:8080/my/path?q=123#ref");
        Assertions.assertThat((String)location.getOrigin()).isEqualTo("http://teamapps.org:8080");
        Assertions.assertThat((String)location.getProtocol()).isEqualTo("http");
        Assertions.assertThat((String)location.getHost()).isEqualTo("teamapps.org:8080");
        Assertions.assertThat((String)location.getHostname()).isEqualTo("teamapps.org");
        Assertions.assertThat((Integer)location.getPort()).isEqualTo(8080);
        Assertions.assertThat((String)location.getPathname()).isEqualTo("/my/path");
        Assertions.assertThat((String)location.getSearch()).isEqualTo("?q=123");
        Assertions.assertThat((String)location.getHash()).isEqualTo("#ref");
    }

    @Test
    public void parseMinimal() throws MalformedURLException {
        Location location = Location.parse((String)"http://teamapps.org");
        Assertions.assertThat((String)location.getHref()).isEqualTo("http://teamapps.org");
        Assertions.assertThat((String)location.getOrigin()).isEqualTo("http://teamapps.org");
        Assertions.assertThat((String)location.getProtocol()).isEqualTo("http");
        Assertions.assertThat((String)location.getHost()).isEqualTo("teamapps.org");
        Assertions.assertThat((String)location.getHostname()).isEqualTo("teamapps.org");
        Assertions.assertThat((Integer)location.getPort()).isNull();
        Assertions.assertThat((String)location.getPathname()).isEqualTo("/");
        Assertions.assertThat((String)location.getSearch()).isEqualTo("");
        Assertions.assertThat((String)location.getHash()).isEqualTo("");
    }
}

