/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.util.threading;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.common.util.ExceptionUtil;
import org.teamapps.util.threading.CloseableExecutor;
import org.teamapps.util.threading.MinMaxAverageStats;
import org.teamapps.util.threading.SequentialExecutorFactory;

public class CompletableFutureChainSequentialExecutorFactory
implements SequentialExecutorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletableFutureChainSequentialExecutorFactory.class);
    private final AtomicReference<MinMaxAverageStats> delayStats = new AtomicReference<MinMaxAverageStats>(new MinMaxAverageStats());
    private final AtomicReference<MinMaxAverageStats> executionTimeStats = new AtomicReference<MinMaxAverageStats>(new MinMaxAverageStats());
    private final ExecutorService pool;

    public CompletableFutureChainSequentialExecutorFactory(int nThreads) {
        this(Executors.newFixedThreadPool(nThreads));
    }

    public CompletableFutureChainSequentialExecutorFactory(ExecutorService executorService) {
        this.pool = executorService;
        ScheduledExecutorService statsLogExecutorService = Executors.newSingleThreadScheduledExecutor();
        statsLogExecutorService.scheduleAtFixedRate(() -> {
            MinMaxAverageStats delayStats = this.delayStats.getAndSet(new MinMaxAverageStats());
            MinMaxAverageStats executionTimeStats = this.executionTimeStats.getAndSet(new MinMaxAverageStats());
            if (delayStats.getMax() > 3000L) {
                LOGGER.warn("Delays critical: min: {}, max: {}, avg: {}, count: {}", new Object[]{delayStats.getMin(), delayStats.getMax(), delayStats.getAvg(), delayStats.getCount()});
            }
            if (executionTimeStats.getMax() > 1000L) {
                LOGGER.warn("Execution times critical: min: {}, max: {}, avg: {}, count: {}", new Object[]{executionTimeStats.getMin(), executionTimeStats.getMax(), executionTimeStats.getAvg(), executionTimeStats.getCount()});
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public CloseableExecutor createExecutor() {
        return this.createExecutor("unnamed");
    }

    @Override
    public CloseableExecutor createExecutor(String name) {
        return new SequentialExecutor(name);
    }

    public class SequentialExecutor
    implements CloseableExecutor {
        private final String name;
        private CompletableFuture<?> lastFuture = CompletableFuture.completedFuture(null);
        private final AtomicInteger queueSize = new AtomicInteger(0);

        public SequentialExecutor(String name) {
            this.name = name;
        }

        @Override
        public synchronized void execute(Runnable command) {
            int queueSize = this.queueSize.incrementAndGet();
            LOGGER.trace("{}: Queue size: {}", (Object)this.name, (Object)queueSize);
            if (queueSize >= 500 && queueSize % 10 == 0) {
                LOGGER.warn("{}: Queue is very long: {}", (Object)this.name, (Object)queueSize);
            }
            long submitTime = System.currentTimeMillis();
            this.lastFuture = ((CompletableFuture)this.lastFuture.thenApplyAsync(o -> {
                long executionStartTime = System.currentTimeMillis();
                long delay = executionStartTime - submitTime;
                CompletableFutureChainSequentialExecutorFactory.this.delayStats.getAndUpdate(minMaxAverageStats -> minMaxAverageStats.push(delay));
                Object result = ExceptionUtil.softenExceptions(() -> {
                    command.run();
                    return null;
                });
                long executionTime = System.currentTimeMillis() - executionStartTime;
                CompletableFutureChainSequentialExecutorFactory.this.executionTimeStats.getAndUpdate(minMaxAverageStats -> minMaxAverageStats.push(executionTime));
                this.queueSize.decrementAndGet();
                return result;
            }, (Executor)CompletableFutureChainSequentialExecutorFactory.this.pool)).exceptionally(throwable -> {
                LOGGER.error("{}: Error while executing: ", (Object)this.name, throwable);
                return null;
            });
        }

        @Override
        public void close() {
        }
    }

    public static class SequentialExecutorClosedException
    extends RuntimeException {
    }
}

