/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.multicurrency;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.teamapps.dto.UiCurrencyField;
import org.teamapps.dto.UiCurrencyUnit;
import org.teamapps.dto.UiCurrencyValue;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.event.Event;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.SpecialKey;
import org.teamapps.ux.component.field.TextInputHandlingField;
import org.teamapps.ux.component.field.multicurrency.value.CurrencyUnit;
import org.teamapps.ux.component.field.multicurrency.value.CurrencyValue;
import org.teamapps.ux.session.SessionContext;

public class CurrencyField
extends AbstractField<CurrencyValue>
implements TextInputHandlingField {
    public final Event<String> onTextInput = new Event();
    public final Event<SpecialKey> onSpecialKeyPressed = new Event();
    private ULocale locale = SessionContext.current().getULocale();
    private List<CurrencyUnit> currencies;
    private int fixedPrecision = -1;
    private boolean alphabeticKeysQueryEnabled = true;
    private boolean currencyBeforeAmount;
    private boolean currencySymbolsEnabled = true;

    public CurrencyField() {
        this(CurrencyUnit.getAllAvailableFromJdk());
    }

    public CurrencyField(List<CurrencyUnit> currencies) {
        this.currencies = currencies;
    }

    public UiField createUiComponent() {
        UiCurrencyField field = new UiCurrencyField();
        this.mapAbstractFieldAttributesToUiField((UiField)field);
        field.setCurrencyUnits(this.currencies.stream().map(unit -> unit.toUiCurrencyUnit(this.locale.toLocale())).collect(Collectors.toList()));
        field.setFixedPrecision(this.fixedPrecision);
        field.setShowCurrencyBeforeAmount(this.currencyBeforeAmount);
        field.setShowCurrencySymbol(this.currencySymbolsEnabled);
        field.setAlphaKeysQueryForCurrency(this.alphabeticKeysQueryEnabled);
        field.setLocale(this.locale.toLanguageTag());
        return field;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        this.defaultHandleTextInputEvent(event);
    }

    public List<CurrencyUnit> getCurrencies() {
        return this.currencies;
    }

    public CurrencyField setCurrencies(List<CurrencyUnit> currencies) {
        this.currencies = currencies;
        this.queueCommandIfRendered(() -> new UiCurrencyField.SetCurrencyUnitsCommand(this.getId(), currencies != null ? currencies.stream().map(unit -> unit.toUiCurrencyUnit(this.locale.toLocale())).collect(Collectors.toList()) : null));
        return this;
    }

    @Override
    public Object convertUxValueToUiValue(CurrencyValue currencyValue) {
        return currencyValue != null ? currencyValue.toUiCurrencyValue(this.locale.toLocale()) : null;
    }

    @Override
    public CurrencyValue convertUiValueToUxValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof UiCurrencyValue) {
            UiCurrencyValue uiCurrencyValue = (UiCurrencyValue)value;
            String uiAmount = uiCurrencyValue.getAmount();
            BigDecimal uxAmount = uiAmount != null ? new BigDecimal(uiAmount) : null;
            UiCurrencyUnit uiCurrencyUnit = uiCurrencyValue.getCurrencyUnit();
            CurrencyUnit uxCurrencyUnit = uiCurrencyUnit != null ? this.currencies.stream().filter(cu -> cu.getCode().equals(uiCurrencyUnit.getCode()) && cu.getFractionDigits() == uiCurrencyUnit.getFractionDigits()).findFirst().orElseGet(() -> CurrencyUnit.from(uiCurrencyUnit.getCode(), uiCurrencyUnit.getFractionDigits(), uiCurrencyUnit.getName(), uiCurrencyUnit.getSymbol())) : null;
            return new CurrencyValue(uxCurrencyUnit, uxAmount);
        }
        throw new IllegalArgumentException("Unknown value type for CurrencyField: " + value.getClass().getCanonicalName());
    }

    public Optional<CurrencyUnit> getCurrency() {
        CurrencyValue value = (CurrencyValue)this.getValue();
        return value != null ? value.getCurrency() : Optional.empty();
    }

    public void setCurrency(CurrencyUnit currencyUnit) {
        CurrencyValue value = (CurrencyValue)this.getValue();
        this.setValue(value != null ? value.withCurrencyUnit(currencyUnit) : new CurrencyValue(currencyUnit, null));
    }

    public Optional<BigDecimal> getAmount() {
        CurrencyValue value = (CurrencyValue)this.getValue();
        return value != null ? value.getAmount() : Optional.empty();
    }

    public void setAmount(BigDecimal amount) {
        CurrencyValue value = (CurrencyValue)this.getValue();
        this.setValue(value != null ? value.withAmount(amount) : new CurrencyValue(null, amount));
    }

    public int getFixedPrecision() {
        return this.fixedPrecision;
    }

    public boolean isCurrencyBeforeAmount() {
        return this.currencyBeforeAmount;
    }

    public CurrencyField setCurrencyBeforeAmount(boolean currencyBeforeAmount) {
        this.currencyBeforeAmount = currencyBeforeAmount;
        this.queueCommandIfRendered(() -> new UiCurrencyField.SetShowCurrencyBeforeAmountCommand(this.getId(), currencyBeforeAmount));
        return this;
    }

    public boolean isCurrencySymbolsEnabled() {
        return this.currencySymbolsEnabled;
    }

    public CurrencyField setCurrencySymbolsEnabled(boolean currencySymbolsEnabled) {
        this.currencySymbolsEnabled = currencySymbolsEnabled;
        this.queueCommandIfRendered(() -> new UiCurrencyField.SetShowCurrencySymbolCommand(this.getId(), currencySymbolsEnabled));
        return this;
    }

    public boolean isAlphabeticKeysQueryEnabled() {
        return this.alphabeticKeysQueryEnabled;
    }

    public void setFixedPrecision(int fixedPrecision) {
        this.fixedPrecision = fixedPrecision;
        this.queueCommandIfRendered(() -> new UiCurrencyField.SetFixedPrecisionCommand(this.getId(), fixedPrecision));
    }

    public void setAlphabeticKeysQueryEnabled(boolean alphabeticKeysQueryEnabled) {
        boolean changed = alphabeticKeysQueryEnabled != this.alphabeticKeysQueryEnabled;
        this.alphabeticKeysQueryEnabled = alphabeticKeysQueryEnabled;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public Locale getLocale() {
        return this.locale.toLocale();
    }

    public ULocale getULocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.setULocale(ULocale.forLocale((Locale)locale));
    }

    public void setULocale(ULocale locale) {
        this.locale = locale;
        this.setCurrencies(this.currencies);
        this.queueCommandIfRendered(() -> new UiCurrencyField.SetLocaleCommand(this.getId(), locale.toLanguageTag()));
    }

    @Override
    public Event<String> onTextInput() {
        return this.onTextInput;
    }

    @Override
    public Event<SpecialKey> onSpecialKeyPressed() {
        return this.onSpecialKeyPressed;
    }
}

