/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.media.shaka;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.teamapps.common.format.Color;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiShakaManifest;
import org.teamapps.dto.UiShakaPlayer;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.media.PosterImageSize;
import org.teamapps.ux.component.media.TrackLabelFormat;
import org.teamapps.ux.component.media.shaka.ControlPanelElementType;
import org.teamapps.ux.component.media.shaka.SkipClickedEvent;
import org.teamapps.ux.session.SessionContext;

public class ShakaPlayer
extends AbstractComponent {
    public final Event<Void> onErrorLoading = new Event();
    public final Event<UiShakaManifest> onManifestLoaded = new Event();
    public final Event<Long> onTimeUpdate = new Event();
    public final Event<Void> onEnded = new Event();
    public final Event<SkipClickedEvent> onSkipClicked = new Event();
    private String hlsUrl;
    private String dashUrl;
    private String posterImageUrl;
    private PosterImageSize posterImageSize = PosterImageSize.CONTAIN;
    private int timeUpdateEventThrottleMillis = 1000;
    private Color backgroundColor = Color.BLACK;
    private TrackLabelFormat trackLabelFormat = TrackLabelFormat.LABEL;
    private boolean videoDisabled = false;
    private String audioLanguage;
    private boolean bigPlayButtonEnabled = true;
    private int controlFadeDelaySeconds = 0;
    private List<ControlPanelElementType> controlPanelElements = List.of(ControlPanelElementType.PLAY_PAUSE, ControlPanelElementType.TIME_AND_DURATION, ControlPanelElementType.SPACER, ControlPanelElementType.MUTE, ControlPanelElementType.VOLUME, ControlPanelElementType.FULLSCREEN, ControlPanelElementType.OVERFLOW_MENU);
    private long timeMillis = 0L;

    public static void setDistinctManifestAudioTracksFixEnabled(boolean enabled) {
        SessionContext.current().queueCommand((UiCommand<?>)new UiShakaPlayer.SetDistinctManifestAudioTracksFixEnabledCommand(enabled));
    }

    public ShakaPlayer() {
    }

    public ShakaPlayer(String hlsUrl, String dashUrl) {
        this.hlsUrl = hlsUrl;
        this.dashUrl = dashUrl;
    }

    @Override
    public UiComponent createUiComponent() {
        UiShakaPlayer ui = new UiShakaPlayer();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setHlsUrl(this.hlsUrl);
        ui.setDashUrl(this.dashUrl);
        ui.setPosterImageUrl(this.posterImageUrl);
        ui.setPosterImageSize(this.posterImageSize.toUiPosterImageSize());
        ui.setTimeUpdateEventThrottleMillis(this.timeUpdateEventThrottleMillis);
        ui.setBackgroundColor(this.backgroundColor != null ? this.backgroundColor.toHtmlColorString() : null);
        ui.setTrackLabelFormat(this.trackLabelFormat.toUiTrackLabelFormat());
        ui.setVideoDisabled(this.videoDisabled);
        ui.setTimeMillis(this.timeMillis);
        ui.setPreferredAudioLanguage(this.audioLanguage);
        ui.setBigPlayButtonEnabled(this.bigPlayButtonEnabled);
        ui.setControlFadeDelaySeconds(this.controlFadeDelaySeconds);
        ui.setControlPanelElements(this.controlPanelElements.stream().map(t -> t.toUiShakaPlayerControlPanelElementType()).collect(Collectors.toList()));
        return ui;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_SHAKA_PLAYER_ERROR_LOADING: {
                this.onErrorLoading.fire(null);
                break;
            }
            case UI_SHAKA_PLAYER_MANIFEST_LOADED: {
                UiShakaPlayer.ManifestLoadedEvent e = (UiShakaPlayer.ManifestLoadedEvent)event;
                this.onManifestLoaded.fire(e.getManifest());
                break;
            }
            case UI_SHAKA_PLAYER_TIME_UPDATE: {
                UiShakaPlayer.TimeUpdateEvent e = (UiShakaPlayer.TimeUpdateEvent)event;
                this.onTimeUpdate.fire(e.getTimeMillis());
                this.timeMillis = e.getTimeMillis();
                break;
            }
            case UI_SHAKA_PLAYER_ENDED: {
                this.onEnded.fire();
                break;
            }
            case UI_SHAKA_PLAYER_SKIP_CLICKED: {
                UiShakaPlayer.SkipClickedEvent e = (UiShakaPlayer.SkipClickedEvent)event;
                this.onSkipClicked.fire(new SkipClickedEvent(e.getForward(), e.getPlaybackTimeMillis()));
                break;
            }
        }
    }

    public void jumpTo(long timeMillis) {
        this.timeMillis = timeMillis;
        this.queueCommandIfRendered(() -> new UiShakaPlayer.JumpToCommand(this.getId(), timeMillis));
    }

    public long getTime() {
        return this.timeMillis;
    }

    public void setUrls(String hlsUrl, String dashUrl) {
        this.timeMillis = 0L;
        this.hlsUrl = hlsUrl;
        this.dashUrl = dashUrl;
        this.queueCommandIfRendered(() -> new UiShakaPlayer.SetUrlsCommand(this.getId(), hlsUrl, dashUrl));
    }

    public String getHlsUrl() {
        return this.hlsUrl;
    }

    public void setHlsUrl(String hlsUrl) {
        this.setUrls(hlsUrl, this.dashUrl);
    }

    public String getDashUrl() {
        return this.dashUrl;
    }

    public void setDashUrl(String dashUrl) {
        this.setUrls(this.hlsUrl, dashUrl);
    }

    public String getPosterImageUrl() {
        return this.posterImageUrl;
    }

    public void setPosterImageUrl(String posterImageUrl) {
        boolean changed = !Objects.equals(posterImageUrl, this.posterImageUrl);
        this.posterImageUrl = posterImageUrl;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public PosterImageSize getPosterImageSize() {
        return this.posterImageSize;
    }

    public void setPosterImageSize(PosterImageSize posterImageSize) {
        boolean changed = posterImageSize != this.posterImageSize;
        this.posterImageSize = posterImageSize;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public int getTimeUpdateEventThrottleMillis() {
        return this.timeUpdateEventThrottleMillis;
    }

    public void setTimeUpdateEventThrottleMillis(int timeUpdateEventThrottleMillis) {
        boolean changed = timeUpdateEventThrottleMillis != this.timeUpdateEventThrottleMillis;
        this.timeUpdateEventThrottleMillis = timeUpdateEventThrottleMillis;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        boolean changed = !Objects.equals(backgroundColor, this.backgroundColor);
        this.backgroundColor = backgroundColor;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public TrackLabelFormat getTrackLabelFormat() {
        return this.trackLabelFormat;
    }

    public void setTrackLabelFormat(TrackLabelFormat trackLabelFormat) {
        boolean changed = trackLabelFormat != this.trackLabelFormat;
        this.trackLabelFormat = trackLabelFormat;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public boolean isVideoDisabled() {
        return this.videoDisabled;
    }

    public void setVideoDisabled(boolean videoDisabled) {
        boolean changed = videoDisabled != this.videoDisabled;
        this.videoDisabled = videoDisabled;
        if (changed) {
            this.reRenderIfRendered();
        }
    }

    public void selectAudioLanguage(String language) {
        this.selectAudioLanguage(language, null);
    }

    public void selectAudioLanguage(String language, String role) {
        this.audioLanguage = language;
        this.queueCommandIfRendered(() -> new UiShakaPlayer.SelectAudioLanguageCommand(this.getId(), language, role));
    }

    public boolean isBigPlayButtonEnabled() {
        return this.bigPlayButtonEnabled;
    }

    public void setBigPlayButtonEnabled(boolean bigPlayButtonEnabled) {
        this.bigPlayButtonEnabled = bigPlayButtonEnabled;
        this.reRenderIfRendered();
    }

    public int getControlFadeDelaySeconds() {
        return this.controlFadeDelaySeconds;
    }

    public void setControlFadeDelaySeconds(int controlFadeDelaySeconds) {
        this.controlFadeDelaySeconds = controlFadeDelaySeconds;
        this.reRenderIfRendered();
    }

    public List<ControlPanelElementType> getControlPanelElements() {
        return this.controlPanelElements;
    }

    public void setControlPanelElements(List<ControlPanelElementType> controlPanelElements) {
        this.controlPanelElements = controlPanelElements;
        this.reRenderIfRendered();
    }

    public void play() {
        this.queueCommandIfRendered(() -> new UiShakaPlayer.PlayCommand(this.getId()));
    }

    public void pause() {
        this.queueCommandIfRendered(() -> new UiShakaPlayer.PauseCommand(this.getId()));
    }
}

