/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.webrtc;

import java.util.Objects;
import org.teamapps.dto.UiAudioTrackConstraints;

public class AudioTrackConstraints {
    private String deviceId = null;
    private int channelCount = 1;
    private boolean autoGainControl = true;
    private double gainFactor = 1.0;
    private boolean echoCancellation = true;
    private boolean noiseSuppression = true;

    public AudioTrackConstraints() {
    }

    public AudioTrackConstraints(boolean autoGainControl, boolean echoCancellation, boolean noiseSuppression) {
        this.autoGainControl = autoGainControl;
        this.echoCancellation = echoCancellation;
        this.noiseSuppression = noiseSuppression;
    }

    public AudioTrackConstraints(int channelCount, boolean autoGainControl, boolean echoCancellation, boolean noiseSuppression) {
        this.channelCount = channelCount;
        this.autoGainControl = autoGainControl;
        this.echoCancellation = echoCancellation;
        this.noiseSuppression = noiseSuppression;
    }

    public UiAudioTrackConstraints createUiAudioTrackConstraints() {
        UiAudioTrackConstraints ui = new UiAudioTrackConstraints();
        ui.setChannelCount(this.channelCount);
        ui.setAutoGainControl(this.autoGainControl);
        ui.setGainFactor(this.gainFactor);
        ui.setEchoCancellation(this.echoCancellation);
        ui.setNoiseSuppression(this.noiseSuppression);
        ui.setDeviceId(this.deviceId);
        return ui;
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public void setChannelCount(int channelCount) {
        this.channelCount = channelCount;
    }

    public boolean isAutoGainControl() {
        return this.autoGainControl;
    }

    public void setAutoGainControl(boolean autoGainControl) {
        this.autoGainControl = autoGainControl;
    }

    public boolean isEchoCancellation() {
        return this.echoCancellation;
    }

    public void setEchoCancellation(boolean echoCancellation) {
        this.echoCancellation = echoCancellation;
    }

    public boolean isNoiseSuppression() {
        return this.noiseSuppression;
    }

    public void setNoiseSuppression(boolean noiseSuppression) {
        this.noiseSuppression = noiseSuppression;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public double getGainFactor() {
        return this.gainFactor;
    }

    public void setGainFactor(double gainFactor) {
        this.gainFactor = gainFactor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AudioTrackConstraints)) {
            return false;
        }
        AudioTrackConstraints that = (AudioTrackConstraints)o;
        return this.channelCount == that.channelCount && this.autoGainControl == that.autoGainControl && Double.compare(that.gainFactor, this.gainFactor) == 0 && this.echoCancellation == that.echoCancellation && this.noiseSuppression == that.noiseSuppression && Objects.equals(this.deviceId, that.deviceId);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.channelCount, this.autoGainControl, this.gainFactor, this.echoCancellation, this.noiseSuppression);
    }
}

