/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph.datapoints;

import java.util.Objects;
import java.util.stream.Stream;
import org.teamapps.dto.UiGraphData;
import org.teamapps.dto.UiHoseGraphData;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.datapoints.GraphData;
import org.teamapps.ux.component.timegraph.datapoints.LineGraphData;

public interface HoseGraphData
extends GraphData {
    public LineGraphData getMiddleLineData();

    public LineGraphData getLowerLineData();

    public LineGraphData getUpperLineData();

    @Override
    default public Interval getInterval() {
        return Stream.of(this.getMiddleLineData(), this.getLowerLineData(), this.getUpperLineData()).filter(Objects::nonNull).map(lineGraphData -> lineGraphData.getInterval()).reduce(Interval::intersection).orElse(Interval.empty());
    }

    @Override
    default public UiGraphData toUiGraphData() {
        LineGraphData lowerLineData = this.getLowerLineData();
        LineGraphData middleLineData = this.getMiddleLineData();
        LineGraphData upperLineData = this.getUpperLineData();
        return new UiHoseGraphData(lowerLineData != null ? lowerLineData.toUiGraphData() : null, middleLineData != null ? middleLineData.toUiGraphData() : null, upperLineData != null ? upperLineData.toUiGraphData() : null, this.getInterval().toUiLongInterval());
    }
}

