/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.workspacelayout.definition;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.teamapps.ux.component.splitpane.SplitSizePolicy;
import org.teamapps.ux.component.workspacelayout.SplitDirection;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayout;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutItem;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutSplitPane;
import org.teamapps.ux.component.workspacelayout.definition.LayoutItemDefinition;
import org.teamapps.ux.component.workspacelayout.definition.SplitSize;
import org.teamapps.ux.component.workspacelayout.definition.ViewDefinition;
import org.teamapps.ux.component.workspacelayout.definition.ViewGroupDefinition;

public class SplitPaneDefinition
extends LayoutItemDefinition {
    private final SplitDirection splitDirection;
    private SplitSizePolicy sizePolicy;
    private float referenceChildSize;
    private LayoutItemDefinition firstChild;
    private LayoutItemDefinition lastChild;

    public SplitPaneDefinition(String id, SplitDirection splitDirection) {
        super(id);
        this.splitDirection = splitDirection;
    }

    public SplitPaneDefinition(String id, SplitDirection splitDirection, SplitSize splitSize, LayoutItemDefinition firstChild, LayoutItemDefinition lastChild) {
        super(id);
        this.splitDirection = splitDirection;
        this.sizePolicy = splitSize.getSizePolicy();
        this.referenceChildSize = splitSize.getSize();
        this.firstChild = firstChild;
        this.lastChild = lastChild;
        this.updateViewGroupParents();
    }

    public SplitPaneDefinition(String id, SplitDirection splitDirection, SplitSizePolicy sizePolicy, float referenceChildSize, LayoutItemDefinition firstChild, LayoutItemDefinition lastChild) {
        super(id);
        this.splitDirection = splitDirection;
        this.sizePolicy = sizePolicy;
        this.referenceChildSize = referenceChildSize;
        this.firstChild = firstChild;
        this.lastChild = lastChild;
        this.updateViewGroupParents();
    }

    private void updateViewGroupParents() {
        if (this.firstChild != null && this.firstChild instanceof ViewGroupDefinition) {
            ((ViewGroupDefinition)this.firstChild).setParentSplitPane(this);
        }
        if (this.lastChild != null && this.lastChild instanceof ViewGroupDefinition) {
            ((ViewGroupDefinition)this.lastChild).setParentSplitPane(this);
        }
    }

    @Override
    public List<ViewDefinition> getAllViews() {
        ArrayList<ViewDefinition> allViews = new ArrayList<ViewDefinition>();
        if (this.firstChild != null) {
            allViews.addAll(this.firstChild.getAllViews());
        }
        if (this.lastChild != null) {
            allViews.addAll(this.lastChild.getAllViews());
        }
        return allViews;
    }

    @Override
    public List<LayoutItemDefinition> getSelfAndAncestors() {
        ArrayList<LayoutItemDefinition> result = new ArrayList<LayoutItemDefinition>();
        result.add(this);
        if (this.firstChild != null) {
            result.addAll(this.firstChild.getSelfAndAncestors());
        }
        if (this.lastChild != null) {
            result.addAll(this.lastChild.getSelfAndAncestors());
        }
        return result;
    }

    @Override
    public WorkSpaceLayoutItem createHeavyWeightItem(WorkSpaceLayout workSpaceLayout) {
        WorkSpaceLayoutSplitPane layoutSplitPane = new WorkSpaceLayoutSplitPane(this.getId(), this.splitDirection, this.sizePolicy, this.referenceChildSize, workSpaceLayout);
        if (this.firstChild != null) {
            layoutSplitPane.setFirstChild(this.firstChild.createHeavyWeightItem(workSpaceLayout));
        }
        if (this.lastChild != null) {
            layoutSplitPane.setLastChild(this.lastChild.createHeavyWeightItem(workSpaceLayout));
        }
        return layoutSplitPane;
    }

    public SplitDirection getSplitDirection() {
        return this.splitDirection;
    }

    public SplitSizePolicy getSizePolicy() {
        return this.sizePolicy;
    }

    public void setSizePolicy(SplitSizePolicy sizePolicy) {
        this.sizePolicy = sizePolicy;
    }

    public float getReferenceChildSize() {
        return this.referenceChildSize;
    }

    public void setReferenceChildSize(float referenceChildSize) {
        this.referenceChildSize = referenceChildSize;
    }

    public LayoutItemDefinition getFirstChild() {
        return this.firstChild;
    }

    public void setFirstChild(LayoutItemDefinition firstChild) {
        this.firstChild = firstChild;
        this.updateViewGroupParents();
    }

    public LayoutItemDefinition getLastChild() {
        return this.lastChild;
    }

    public void setLastChild(LayoutItemDefinition lastChild) {
        this.lastChild = lastChild;
        this.updateViewGroupParents();
    }

    public String getComparableDefinition() {
        return "SplitPaneDefinition{splitDirection=" + String.valueOf((Object)this.splitDirection) + ", sizePolicy=" + String.valueOf((Object)this.sizePolicy) + ", referenceChildSize=" + this.referenceChildSize + ", firstChild=" + this.getChildLayoutDefinition(this.firstChild) + ", lastChild=" + this.getChildLayoutDefinition(this.lastChild) + "}";
    }

    private String getChildLayoutDefinition(LayoutItemDefinition layoutItemDefinition) {
        if (layoutItemDefinition == null) {
            return null;
        }
        if (layoutItemDefinition instanceof SplitPaneDefinition) {
            SplitPaneDefinition splitPaneDefinition = (SplitPaneDefinition)layoutItemDefinition;
            return splitPaneDefinition.getComparableDefinition();
        }
        return layoutItemDefinition.getClass().getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitPaneDefinition that = (SplitPaneDefinition)o;
        return this.getComparableDefinition().equals(that.getComparableDefinition());
    }

    public int hashCode() {
        return Objects.hash(this.getComparableDefinition());
    }
}

