/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.teamapps.ux.session.navigation.Location;
import org.teamapps.ux.session.navigation.RoutingUtil;

public class Route {
    public static final Route EMPTY = new Route("/", Map.of());
    private static final Pattern RELATIVE_URL_PATTERN = Pattern.compile("(.*?)?(\\?.*?)?(#.*)?");
    private final String relativePath;
    private final Map<String, String> queryParams;

    public static Route create() {
        return EMPTY;
    }

    public static Route parse(String relativeUrl) {
        if (StringUtils.isBlank((CharSequence)relativeUrl)) {
            return new Route("/", Map.of());
        }
        Matcher matcher = RELATIVE_URL_PATTERN.matcher(relativeUrl);
        if (matcher.matches()) {
            String path = matcher.group(1);
            path = RoutingUtil.normalizePath(path);
            Map<String, String> queryParams = RoutingUtil.parseQueryParams(matcher.group(2));
            return new Route(path, queryParams);
        }
        throw new IllegalArgumentException("Unparsable relative URL: " + relativeUrl);
    }

    public Route(String relativePath, Map<String, String> queryParams) {
        this.relativePath = RoutingUtil.normalizePath(relativePath);
        this.queryParams = queryParams;
    }

    public static Route fromLocation(Location location) {
        return Route.parse(location.getPathname() + location.getSearch());
    }

    public Route subRoute(String pathPrefixToRemove) {
        return new Route(RoutingUtil.removePrefix(this.relativePath, pathPrefixToRemove), this.queryParams);
    }

    public Route withPathSuffix(String pathSuffix) {
        return new Route(RoutingUtil.concatenatePaths(this.relativePath, pathSuffix), this.queryParams);
    }

    public Route withPathPrefix(String pathPrefix) {
        return new Route(RoutingUtil.concatenatePaths(pathPrefix, this.relativePath), this.queryParams);
    }

    public Route withPath(String path) {
        return new Route(path, this.queryParams);
    }

    public Route withQueryParam(String key, String value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return this;
        }
        HashMap<String, String> newQueryParams = new HashMap<String, String>(this.queryParams);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            newQueryParams.put(key, value);
        } else {
            newQueryParams.remove(key);
        }
        return new Route(this.relativePath, newQueryParams);
    }

    public Route withQueryParams(Map<String, String> queryParams) {
        if (queryParams == null || queryParams.isEmpty()) {
            return new Route(this.relativePath, Map.of());
        }
        HashMap<String, String> newQueryParams = new HashMap<String, String>(this.queryParams);
        queryParams.forEach((key, value) -> {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                newQueryParams.put((String)key, (String)value);
            } else {
                newQueryParams.remove(key);
            }
        });
        return new Route(this.relativePath, newQueryParams);
    }

    public String getPath() {
        return this.relativePath;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public String getQueryParam(String name) {
        return this.queryParams.get(name);
    }

    public String toString() {
        return this.relativePath + (String)(!this.queryParams.isEmpty() ? "?" + this.queryParams.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&")) : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Route that = (Route)o;
        return Objects.equals(this.relativePath, that.relativePath) && Objects.equals(this.queryParams, that.queryParams);
    }

    public int hashCode() {
        return Objects.hash(this.relativePath, this.queryParams);
    }
}

