/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph.partitioning;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.junit.Assert;
import org.junit.Test;
import org.teamapps.ux.component.timegraph.TimePartitioningUnit;

public class TimePartitioningUnitTest {
    private static final ZonedDateTime TEST_TIME_UNALIGNED = ZonedDateTime.of(2020, 7, 17, 17, 47, 47, 777777777, ZoneOffset.UTC);
    private static final ZonedDateTime TEST_TIME_INCREMENT = ZonedDateTime.of(2020, 12, 31, 23, 59, 59, 999000000, ZoneOffset.UTC);
    private static final ZonedDateTime TEST_TIME_DECREMENT = ZonedDateTime.of(2020, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);

    @Test
    public void testGetPartition_MILLISECOND() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:47:47.777Z"), (Object)TimePartitioningUnit.MILLISECOND.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_MILLISECOND_2() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:47:47.776Z"), (Object)TimePartitioningUnit.MILLISECOND_2.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_MILLISECOND_5() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:47:47.775Z"), (Object)TimePartitioningUnit.MILLISECOND_5.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_MILLISECOND_10() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:47:47.770Z"), (Object)TimePartitioningUnit.MILLISECOND_10.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_MILLISECOND_20() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:47:47.760Z"), (Object)TimePartitioningUnit.MILLISECOND_20.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_MILLISECOND_50() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:47:47.750Z"), (Object)TimePartitioningUnit.MILLISECOND_50.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_MILLISECOND_100() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:47:47.700Z"), (Object)TimePartitioningUnit.MILLISECOND_100.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_MILLISECOND_200() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:47:47.600Z"), (Object)TimePartitioningUnit.MILLISECOND_200.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_MILLISECOND_500() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:47:47.500Z"), (Object)TimePartitioningUnit.MILLISECOND_500.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_SECOND() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:47:47.000Z"), (Object)TimePartitioningUnit.SECOND.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_SECONDS_2() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:47:46.000Z"), (Object)TimePartitioningUnit.SECONDS_2.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_SECONDS_5() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:47:45.000Z"), (Object)TimePartitioningUnit.SECONDS_5.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_SECONDS_10() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:47:40.000Z"), (Object)TimePartitioningUnit.SECONDS_10.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_SECONDS_15() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:47:45.000Z"), (Object)TimePartitioningUnit.SECONDS_15.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_SECONDS_30() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:47:30.000Z"), (Object)TimePartitioningUnit.SECONDS_30.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_MINUTE() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:47:00.000Z"), (Object)TimePartitioningUnit.MINUTE.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_MINUTES_2() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:46:00.000Z"), (Object)TimePartitioningUnit.MINUTES_2.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_MINUTES_5() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:45:00.000Z"), (Object)TimePartitioningUnit.MINUTES_5.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_MINUTES_10() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:40:00.000Z"), (Object)TimePartitioningUnit.MINUTES_10.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_MINUTES_15() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:45:00.000Z"), (Object)TimePartitioningUnit.MINUTES_15.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_MINUTES_30() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:30:00.000Z"), (Object)TimePartitioningUnit.MINUTES_30.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_HOUR() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T17:00:00.000Z"), (Object)TimePartitioningUnit.HOUR.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_HOURS_6() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T12:00:00.000Z"), (Object)TimePartitioningUnit.HOURS_6.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_HOURS_12() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T12:00:00.000Z"), (Object)TimePartitioningUnit.HOURS_12.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_DAY() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-17T00:00:00.000Z"), (Object)TimePartitioningUnit.DAY.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_WEEK_SUNDAY() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-12T00:00:00.000Z"), (Object)TimePartitioningUnit.WEEK_SUNDAY.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_WEEK_MONDAY() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-13T00:00:00.000Z"), (Object)TimePartitioningUnit.WEEK_MONDAY.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_MONTH() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-01T00:00:00.000Z"), (Object)TimePartitioningUnit.MONTH.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_QUARTER() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-01T00:00:00.000Z"), (Object)TimePartitioningUnit.QUARTER.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_HALF_YEAR() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-07-01T00:00:00.000Z"), (Object)TimePartitioningUnit.HALF_YEAR.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testGetPartition_YEAR() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2020-01-01T00:00:00.000Z"), (Object)TimePartitioningUnit.YEAR.getPartitionStart(TEST_TIME_UNALIGNED));
    }

    @Test
    public void testIncrement_MILLISECOND() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:00:00.000Z"), (Object)TimePartitioningUnit.MILLISECOND.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_MILLISECOND_2() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:00:00.001Z"), (Object)TimePartitioningUnit.MILLISECOND_2.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_MILLISECOND_5() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:00:00.004Z"), (Object)TimePartitioningUnit.MILLISECOND_5.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_MILLISECOND_10() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:00:00.009Z"), (Object)TimePartitioningUnit.MILLISECOND_10.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_MILLISECOND_20() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:00:00.019Z"), (Object)TimePartitioningUnit.MILLISECOND_20.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_MILLISECOND_50() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:00:00.049Z"), (Object)TimePartitioningUnit.MILLISECOND_50.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_MILLISECOND_100() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:00:00.099Z"), (Object)TimePartitioningUnit.MILLISECOND_100.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_MILLISECOND_200() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:00:00.199Z"), (Object)TimePartitioningUnit.MILLISECOND_200.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_MILLISECOND_500() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:00:00.499Z"), (Object)TimePartitioningUnit.MILLISECOND_500.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_SECOND() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:00:00.999Z"), (Object)TimePartitioningUnit.SECOND.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_SECONDS_2() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:00:01.999Z"), (Object)TimePartitioningUnit.SECONDS_2.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_SECONDS_5() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:00:04.999Z"), (Object)TimePartitioningUnit.SECONDS_5.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_SECONDS_10() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:00:09.999Z"), (Object)TimePartitioningUnit.SECONDS_10.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_SECONDS_15() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:00:14.999Z"), (Object)TimePartitioningUnit.SECONDS_15.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_SECONDS_30() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:00:29.999Z"), (Object)TimePartitioningUnit.SECONDS_30.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_MINUTE() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:00:59.999Z"), (Object)TimePartitioningUnit.MINUTE.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_MINUTES_2() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:01:59.999Z"), (Object)TimePartitioningUnit.MINUTES_2.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_MINUTES_5() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:04:59.999Z"), (Object)TimePartitioningUnit.MINUTES_5.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_MINUTES_10() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:09:59.999Z"), (Object)TimePartitioningUnit.MINUTES_10.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_MINUTES_15() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:14:59.999Z"), (Object)TimePartitioningUnit.MINUTES_15.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_MINUTES_30() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:29:59.999Z"), (Object)TimePartitioningUnit.MINUTES_30.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_HOUR() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T00:59:59.999Z"), (Object)TimePartitioningUnit.HOUR.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_HOURS_6() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T05:59:59.999Z"), (Object)TimePartitioningUnit.HOURS_6.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_HOURS_12() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T11:59:59.999Z"), (Object)TimePartitioningUnit.HOURS_12.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_DAY() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-01T23:59:59.999Z"), (Object)TimePartitioningUnit.DAY.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_WEEK_SUNDAY() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-07T23:59:59.999Z"), (Object)TimePartitioningUnit.WEEK_SUNDAY.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_WEEK_MONDAY() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-07T23:59:59.999Z"), (Object)TimePartitioningUnit.WEEK_MONDAY.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_MONTH() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-01-31T23:59:59.999Z"), (Object)TimePartitioningUnit.MONTH.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_QUARTER() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-03-31T23:59:59.999Z"), (Object)TimePartitioningUnit.QUARTER.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_HALF_YEAR() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-06-30T23:59:59.999Z"), (Object)TimePartitioningUnit.HALF_YEAR.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testIncrement_YEAR() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2021-12-31T23:59:59.999Z"), (Object)TimePartitioningUnit.YEAR.increment(TEST_TIME_INCREMENT));
    }

    @Test
    public void testDecrement_MILLISECOND() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:59:59.999Z"), (Object)TimePartitioningUnit.MILLISECOND.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_MILLISECOND_2() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:59:59.998Z"), (Object)TimePartitioningUnit.MILLISECOND_2.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_MILLISECOND_5() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:59:59.995Z"), (Object)TimePartitioningUnit.MILLISECOND_5.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_MILLISECOND_10() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:59:59.990Z"), (Object)TimePartitioningUnit.MILLISECOND_10.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_MILLISECOND_20() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:59:59.980Z"), (Object)TimePartitioningUnit.MILLISECOND_20.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_MILLISECOND_50() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:59:59.950Z"), (Object)TimePartitioningUnit.MILLISECOND_50.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_MILLISECOND_100() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:59:59.900Z"), (Object)TimePartitioningUnit.MILLISECOND_100.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_MILLISECOND_200() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:59:59.800Z"), (Object)TimePartitioningUnit.MILLISECOND_200.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_MILLISECOND_500() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:59:59.500Z"), (Object)TimePartitioningUnit.MILLISECOND_500.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_SECOND() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:59:59.000Z"), (Object)TimePartitioningUnit.SECOND.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_SECONDS_2() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:59:58.000Z"), (Object)TimePartitioningUnit.SECONDS_2.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_SECONDS_5() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:59:55.000Z"), (Object)TimePartitioningUnit.SECONDS_5.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_SECONDS_10() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:59:50.000Z"), (Object)TimePartitioningUnit.SECONDS_10.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_SECONDS_15() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:59:45.000Z"), (Object)TimePartitioningUnit.SECONDS_15.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_SECONDS_30() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:59:30.000Z"), (Object)TimePartitioningUnit.SECONDS_30.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_MINUTE() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:59:00.000Z"), (Object)TimePartitioningUnit.MINUTE.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_MINUTES_2() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:58:00.000Z"), (Object)TimePartitioningUnit.MINUTES_2.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_MINUTES_5() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:55:00.000Z"), (Object)TimePartitioningUnit.MINUTES_5.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_MINUTES_10() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:50:00.000Z"), (Object)TimePartitioningUnit.MINUTES_10.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_MINUTES_15() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:45:00.000Z"), (Object)TimePartitioningUnit.MINUTES_15.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_MINUTES_30() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:30:00.000Z"), (Object)TimePartitioningUnit.MINUTES_30.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_HOUR() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T23:00:00.000Z"), (Object)TimePartitioningUnit.HOUR.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_HOURS_6() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T18:00:00.000Z"), (Object)TimePartitioningUnit.HOURS_6.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_HOURS_12() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T12:00:00.000Z"), (Object)TimePartitioningUnit.HOURS_12.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_DAY() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-31T00:00:00.000Z"), (Object)TimePartitioningUnit.DAY.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_WEEK_SUNDAY() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-25T00:00:00.000Z"), (Object)TimePartitioningUnit.WEEK_SUNDAY.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_WEEK_MONDAY() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-25T00:00:00.000Z"), (Object)TimePartitioningUnit.WEEK_MONDAY.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_MONTH() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-12-01T00:00:00.000Z"), (Object)TimePartitioningUnit.MONTH.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_QUARTER() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-10-01T00:00:00.000Z"), (Object)TimePartitioningUnit.QUARTER.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_HALF_YEAR() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-07-01T00:00:00.000Z"), (Object)TimePartitioningUnit.HALF_YEAR.decrement(TEST_TIME_DECREMENT));
    }

    @Test
    public void testDecrement_YEAR() throws Exception {
        Assert.assertEquals((Object)ZonedDateTime.parse("2019-01-01T00:00:00.000Z"), (Object)TimePartitioningUnit.YEAR.decrement(TEST_TIME_DECREMENT));
    }
}

