/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.component.field.validator.CustomValidator;

public class MultiFieldValidator {
    private final Runnable runValidationHandler = this::validate;
    private final Runnable clearMessagesHandler = this::clearMessages;
    private final CustomValidator validation;
    private final List<AbstractField<?>> fields;
    private List<FieldMessage> currentFieldMessages = List.of();
    private final TriggeringPolicy triggeringPolicy;

    public MultiFieldValidator(CustomValidator validation, AbstractField<?> ... fields) {
        this(validation, TriggeringPolicy.MANUALLY, Arrays.asList(fields));
    }

    public MultiFieldValidator(CustomValidator validation, TriggeringPolicy triggeringPolicy, AbstractField<?> ... fields) {
        this(validation, triggeringPolicy, Arrays.asList(fields));
    }

    public MultiFieldValidator(CustomValidator validation, TriggeringPolicy triggeringPolicy, List<AbstractField<?>> fields) {
        this.validation = validation;
        this.fields = new ArrayList(fields);
        this.triggeringPolicy = triggeringPolicy;
        this.setupTriggeringPolicy();
    }

    public List<FieldMessage> validate() {
        List<FieldMessage> validationResult = this.validation.validate();
        List<FieldMessage> newFieldMessages = validationResult != null ? validationResult : List.of();
        this.fields.forEach(f -> {
            this.currentFieldMessages.forEach(f::removeCustomFieldMessage);
            newFieldMessages.forEach(f::addCustomFieldMessage);
        });
        this.currentFieldMessages = newFieldMessages;
        return newFieldMessages;
    }

    private void setupTriggeringPolicy() {
        switch (this.triggeringPolicy.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                this.fields.forEach(f -> f.onValueChanged.addListener(this.clearMessagesHandler));
                break;
            }
            case 2: {
                this.fields.forEach(f -> f.onValueChanged.addListener(this.runValidationHandler));
            }
        }
    }

    public TriggeringPolicy getTriggeringPolicy() {
        return this.triggeringPolicy;
    }

    public void clearMessages() {
        this.fields.forEach(AbstractField::clearCustomFieldMessages);
    }

    public static enum TriggeringPolicy {
        MANUALLY,
        MANUALLY_WITH_AUTOCLEAR,
        ON_FIELD_CHANGE;

    }
}

