/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session.navigation;

import jakarta.inject.Inject;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.glassfish.jersey.internal.inject.ParamConverters;

public class ParameterConverterProvider
implements ParamConverterProvider {
    private final List<ParamConverterProvider> providers;

    @Inject
    public ParameterConverterProvider() {
        try {
            this.providers = new ArrayList<ListParamConverterProvider>(List.of(ParameterConverterProvider.createInternalJerseyParameterConverter(ParamConverters.DateProvider.class), ParameterConverterProvider.createInternalJerseyParameterConverter(ParamConverters.TypeFromStringEnum.class), ParameterConverterProvider.createInternalJerseyParameterConverter(ParamConverters.TypeValueOf.class), ParameterConverterProvider.createInternalJerseyParameterConverter(ParamConverters.CharacterProvider.class), ParameterConverterProvider.createInternalJerseyParameterConverter(ParamConverters.TypeFromString.class), ParameterConverterProvider.createInternalJerseyParameterConverter(ParamConverters.StringConstructor.class), ParameterConverterProvider.createInternalJerseyParameterConverter(ParamConverters.OptionalProvider.class), new ListParamConverterProvider()));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static ParamConverterProvider createInternalJerseyParameterConverter(Class<? extends ParamConverterProvider> paramConverterClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor<?>[] declaredConstructors = paramConverterClass.getDeclaredConstructors();
        Optional<Constructor> noArgConstructor = Arrays.stream(declaredConstructors).filter(constructor -> constructor.getParameterCount() == 0).findFirst();
        if (noArgConstructor.isPresent()) {
            return (ParamConverterProvider)noArgConstructor.get().newInstance(new Object[0]);
        }
        Constructor throwOnNullConstructor = Arrays.stream(declaredConstructors).filter(constructor -> Arrays.equals(constructor.getParameterTypes(), new Class[]{Boolean.TYPE})).findFirst().orElseThrow(InstantiationError::new);
        if (Modifier.isPrivate(throwOnNullConstructor.getModifiers())) {
            throwOnNullConstructor.setAccessible(true);
        }
        return (ParamConverterProvider)throwOnNullConstructor.newInstance(false);
    }

    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        for (ParamConverterProvider p : this.providers) {
            ParamConverter reader = p.getConverter(rawType, genericType, annotations);
            if (reader == null) continue;
            return reader;
        }
        return null;
    }

    public void addConverterProvider(ParamConverterProvider converterProvider) {
        this.providers.add(0, converterProvider);
    }

    public <T> void addConverter(final Class<T> clazz, final ParamConverter<T> converter) {
        this.providers.add(0, new ParameterConverterProvider(){

            public <X> ParamConverter<X> getConverter(Class<X> rawType, Type genericType, Annotation[] annotations) {
                if (rawType == clazz) {
                    return converter;
                }
                return null;
            }
        });
    }

    private class ListParamConverterProvider
    implements ParamConverterProvider {
        private ListParamConverterProvider() {
        }

        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            if (!List.class.isAssignableFrom(rawType)) {
                return null;
            }
            if (genericType instanceof ParameterizedType) {
                Type parameterType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                return new ListValuedParamConverter(parameterType);
            }
            return null;
        }
    }

    private class ListValuedParamConverter
    implements ParamConverter<List<?>> {
        private final ParamConverter<?> itemConverter;

        public ListValuedParamConverter(Type parameterType) {
            this.itemConverter = ParameterConverterProvider.this.getConverter((Class)parameterType, parameterType, null);
        }

        public List<?> fromString(String param) {
            if (param == null || param.trim().isEmpty()) {
                return null;
            }
            return Arrays.stream(param.split(",")).map(s -> this.itemConverter.fromString(s)).collect(Collectors.toList());
        }

        public String toString(List<?> list) {
            if (list == null || list.isEmpty()) {
                return null;
            }
            return list.stream().map(item -> this.itemConverter.toString(item)).collect(Collectors.joining(","));
        }
    }
}

