/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.uisession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.uisession.CMD;
import org.teamapps.uisession.UnconsumedCommandsOverflowException;

public class CommandBuffer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandBuffer.class);
    private final int maxFillableCapacity;
    private final CMD[] buffer;
    private int head = 0;
    private int nextConsumable = 0;
    private int tail = 0;
    private boolean bufferFlippedAtLeastOnce;

    public CommandBuffer(int capacity) {
        this.maxFillableCapacity = capacity;
        this.buffer = new CMD[this.maxFillableCapacity + 1];
    }

    public int size() {
        return this.head - this.tail + (this.head < this.tail ? this.buffer.length : 0);
    }

    public void addCommand(CMD command) throws UnconsumedCommandsOverflowException {
        if (this.size() == this.maxFillableCapacity) {
            if (this.tail == this.nextConsumable) {
                throw new UnconsumedCommandsOverflowException("Command buffer overflow. Max capacity: " + this.maxFillableCapacity);
            }
            this.tail = (this.tail + 1) % this.buffer.length;
        }
        this.buffer[this.head] = command;
        if (this.head + 1 == this.buffer.length) {
            this.bufferFlippedAtLeastOnce = true;
        }
        this.head = (this.head + 1) % this.buffer.length;
    }

    public CMD consumeCommand() {
        if (this.size() > 0 && this.nextConsumable != this.head) {
            CMD command = this.buffer[this.nextConsumable];
            this.nextConsumable = (this.nextConsumable + 1) % this.buffer.length;
            return command;
        }
        return null;
    }

    public void purgeTillCommand(int commandIdExclusive) {
        while (this.buffer[this.tail].getId() != commandIdExclusive) {
            if (this.tail == this.nextConsumable) {
                LOGGER.error("Will not purge next consumable command!");
                return;
            }
            this.buffer[this.tail] = null;
            this.tail = (this.tail + 1) % this.buffer.length;
        }
    }

    public boolean rewindToCommand(long commandId) {
        int i;
        if (commandId == -1L) {
            if (this.bufferFlippedAtLeastOnce) {
                return false;
            }
            this.nextConsumable = 0;
            return true;
        }
        int n = i = this.tail < this.nextConsumable ? this.nextConsumable - 1 : this.nextConsumable + this.buffer.length - 1;
        while (i >= this.tail) {
            CMD command = this.buffer[i % this.buffer.length];
            if (command == null) {
                return false;
            }
            if ((long)command.getId() == commandId) {
                this.nextConsumable = i + 1;
                return true;
            }
            --i;
        }
        return false;
    }

    public long getNextCommandId() {
        return this.buffer[this.nextConsumable].getId();
    }

    public void clear() {
        this.head = 0;
        this.nextConsumable = 0;
        this.tail = 0;
    }
}

